/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/libsf.h>
#include <pwd.h>

/*
 * mkpath - make complete sound file path, creating directory if necessary.
 * this program must be owned by root to work.
 */

main (argc, argv)
	int     argc;
	char  **argv;
{
	while (--argc)
		if (mkpath (*++argv))
			exit (1);
	exit (0);
}



mkpath (name)
	char   *name;
{
	char   *path,
	       *getsfn();
	char   *getprown();
	setsfile(name);
	path = getsfn(name, 0);
	if (access(path, 0)) { 	/* go make this person a directory */
		extern char 	*getprown();
		char    	cmd[BUFSIZ];

		if (ownspath(path, getprown()) < 0) {
			fprintf (stderr, 
			    "mkpath: no permission to create path: %s\n", path);
			return (-1);
		}
		(void) sprintf (cmd, "/bin/mkdir %s\n", path);
		(void) umask(~(0755));
		/* set execute bits to allow search permission */
		if (sfsystem(cmd)) {			/* shazam! */
			fprintf(stderr, "mkpath: mkdir system call failed.\n");
			return(0);
		}
	}
	else
		printf("mkpath: directory %s already exists.\n", path);
	(void) umask(~(0644));	/* put it back */
	if (path != NULL)
		free(path);
	return (0);
}
