/* wsdf.c	1.3	(CARL)	11/19/84	14:48:09 */
#include <sys/types.h>
#include <sys/dir.h>
#include <stdio.h>
#include <carl/libsf.h>

/*
 * wsdf - write a sound descriptor file.
 * This routine takes an optional file pointer to a file open for writing.
 * If none is supplied, the file named in sdp->sfn, with SDFEXT attached,
 * is opened for writing.  
 */

extern  FILE * lockfopen ();
int	nlwsdf;		/* external in closesf() */

wsdf (fp, sdp)
	FILE *fp;
	struct sndesc  *sdp;
{
	extern char *strcat();
	extern char *strcpy();
	int     closeit = 0;
	struct dskblk  *cp;
	struct inclist *inc;
	struct comlist *com;
	FILE * fopen ();
	struct csnd_prop *pro;

	if (sdp == NULL)
		return (-1);

	if (fp == NULL) {
		extern	char *malloc();
		char    *name;

		if (sdp -> sfn == NULL || !strlen (sdp -> sfn)) {
			return (-1);
		}
		else {
			name = malloc (strlen(sdp -> sfn) + strlen(SDFEXT) + 1);
			if (name == NULL) {
				fprintf (stderr, "wsdf: malloc failed\n");
				return (-1);
			}
			(void) strcpy (name, sdp -> sfn);
			(void) strcat (name, SDFEXT);
		}
		(void) umask (~(0664));
		if ((fp = lockfopen (name, "w")) == NULL) {
			fprintf (stderr, 
			    "wsdf: error opening file %s\n", name);
			(void) free (name);
			return (-1);
		}
		closeit = 1;
		(void) free (name);
	}

	/* write first 4 variables */
	fprintf (fp, "%c %c\n%c %d\n%c %o\n%c %c\n",
		FRTFLAG, sdp -> rtflag,
		FNCYLS, sdp -> ncyls,
		FPROT, sdp -> fprot,
		FHOLD, sdp -> fhold == '\0' ? SCRAT : sdp -> fhold);

	if (sdp -> rw != SFCLOSED) {
		fprintf (fp, "%c ", FRW);
		if (sdp -> rw & SFREAD)
			fprintf (fp, "%c", SRWR);
		if (sdp -> rw & SFWRITE)
			fprintf (fp, "%c", SRWW);
		fprintf (fp, "\n");
		fprintf (fp, "%c %d\n", FPID, sdp -> spid);
	}

	/* write name and owner */
	fprintf (fp, "%c %s\n%c %s\n", FSFN, sdp -> sfn, FSFOWN, sdp -> sfown);

	/* write cylinder blocks */
	for (cp = sdp -> cp; cp != NULL; cp = cp -> next)
		fprintf (fp, "%c %c\t%d\t%d\t%d\n",
		    FCP, cp -> flag, cp -> base, cp -> len, cp -> seq);

	/* write sample parameters */
	fprintf (fp,
	    "%c %f\n%c %c\n%c %u\n%c %d\n%c %u\n%c %u\n%c %u\n%c %u\n%c %u\n",
	    FSR, sdp -> sr, FPM, sdp -> pm, FNC, sdp -> nc, FFS, sdp -> fs,
	    FCD, sdp -> cdate, FRD, sdp -> rdate, FAD, sdp -> adate,
	    FDD, sdp -> dumpd, FTK, sdp -> tpkey);

	/* write comment strings */
	for (com = sdp -> comsdf; com != NULL; com = com -> comnext)
		fprintf (fp, "%c %s\n", FREM, com -> cmt);

	/* write include file strings */
	for (inc = sdp -> inclsdf; inc != NULL; inc = inc -> incnext)
		fprintf (fp, "%c %s\n", FINC, inc -> fn);

	for (pro = sdp->csnd_p; pro != NULL; pro = pro->cprop_next)
		fprintf(fp, "%c %s %s\n", FPROP, pro->cprop_name,
		    pro->cprop_val);

	if (closeit)
		if (lockfclose (fp) < 0) {
			fprintf(stderr, "wsdf: lockfclose failed\n");
			return (-1);
		}

	sync ();		/* flush system buffers */
	return (0);
}
