/* wrtsfb.c	1.1	(CARL)	7/25/84	13:45:12 */
#include <stdio.h>
#include <carl/libsf.h>

/* write sound file buffer in sfd->sb to virtual block blockno */

extern int sferror;

long    wrtsfb (sfd, blockno)
	struct sndesc  *sfd;
	long    blockno;
{
	extern long seeksf();
	register char  *x;

	x = sfd -> pm == PM16BIT ? (char *) sfd -> sb : (char *) sfd -> fb;

	if (seeksf (sfd, blockno * sfd -> bufsiz) < 0)
		return (-1);

	if (write (sfd -> fid, x, sfd -> bufsiz) != sfd -> bufsiz) {
		perror("wrtsfb:write");
		return (-1);
	}
	sfd -> sbcnt = sfd -> nsib;
	sfd -> bdir = sfd -> bfvb = sfd -> sbptr = 0;
	if (sfd -> rw & SFFLUSH)
		if (wsdf ((FILE *) NULL, sfd) != 0) {
			fprintf(stderr, "wrtsfb: wsdf failed\n");
			sferror = IOER;
			return(-1);
		}
	return (sfd -> bufsiz);
}
