/* sndo.c	1.1	(CARL)	7/25/84	13:44:40 */
#include <stdio.h>
#include <carl/libsf.h>
#define min(a,b) ((a) < (b) ? (a) : (b))
#define max(a,b) ((a) > (b) ? (a) : (b))

/*
 * sndo - random access variable length sample output.  args:
 *     sfd = sound file descriptor pointer,
 *     fx  = array of samples to write, interleaved, 
 *     st = index to starting deinterleaved (i.e., absolute) sample in file,
 *     ns = number of deinterleaved samples to write 
 *     op = special operation
 *	  "s" = fx is full of shorts 
 *	  "f" = fx is full of floats
 * 	
 * To append to a file, write with st = sfd->fs.  Writing with 
 * st > sfd->fs causes an error return.  Writing a realtime
 * file with st+ns > sfd->fs expands sfd->fs, out to the limit of 
 * the cylinder allocation.  For non-realtime files writing thusly will
 * simply claim more storage, out to the limit of available storage.
 */

long
sndo (sfd, cx, st, ns, op)
	struct sndesc  *sfd;
	char   *cx;
	long    st;
	long    ns;
	char   *op;
{
	extern char *index();
	extern 	long filsfb();
	extern	long    wrtsfb ();
	long    stblk,
	        xoff,
	        xfrcnt,
	        curblk,
	        ssib,
	        cvtd = 0;
	short  *sx = (short *) cx;
	float  *fx = (float *) cx;
	char    mkpack = PMFLOAT;

	if (op != NULL && index (op, PM16BIT) != NULL)
		mkpack = PM16BIT;
	if (!(sfd->rw & SFWRITE) || sfd->err)
		return (-1);
	if (st > sfd->fs) {	/* see note 1 below */
		sfd->eof = TRUE;
		return (0);
	}
	if (st != sfd->fs && !(sfd->rw & SFREAD)) {
	/* see note 2 below */
		sfd->err = -1;
		return (-1);
	}

	if (sfd->sb == NULL && sfd->fb == NULL)	/* get buffer */
		if (getsfbuf (sfd)) {
			sfd->err = -1;
			return (-1);
		}

	stblk = st / sfd->nsib;			/* starting buffer */
	ssib = st % sfd->nsib;			/* starting sample in buffer */

	if (st+ns > sfd->ncyls * sfd->blksiz / sfd->ssize) {
		/* writing out of bounds we'll run out of room */
		if (sfd->rtflag == RT) {	/* a contiguous file? */
			ns = sfd->ncyls * sfd->blksiz / sfd->ssize - st;
						/* truncate write */
			sfd->eof = TRUE; 	/* set eof */
		}
		else
			if (xpandsf (sfd, 1L) < 0) {	/* look for more */
			    fprintf (stderr,
				"sndo: no more room on the disk for file %s.\n",
				    sfd->sfn);
			    sfd->eof = TRUE;
			    return (-1);
			}
	}

	for (
			curblk = stblk, xoff = 0,
			xfrcnt = min ((sfd->nsib - ssib), ns);
			xfrcnt > 0;
			curblk += 1, ssib = 0, xoff += xfrcnt,
			xfrcnt = min (sfd->nsib, (ns - xoff))
		) {
		register long   i;

		if (curblk != sfd->secptr) {
			if (sfd->secptr >= 0)	/* not the first time */
				if (wrtsfb (sfd, sfd->secptr) < 0L)
					return (-1);
			if (sfd->rw & SFREAD)	/* read/alter? */
				if (filsfb (sfd, curblk) < 0)
					return (-1);
			sfd->secptr = curblk;
		}

		if (mkpack == 'f')		/* user has floats */
			if (sfd->pm == PM16BIT)	/* and file is shorts */
				for (i = 0; i < xfrcnt; i++)
					sfd->sb[i+ssib] = fx[i+xoff] * 32767.0;
			else			/* and file is floats */
				for (i = 0; i < xfrcnt; i++)
					sfd->fb[i+ssib] = fx[i+xoff];
		else				/* user has shorts */
			if (sfd->pm == PMFLOAT)	/* and file is floats */
				for (i = 0; i < xfrcnt; i++)
					sfd->fb[i+ssib] = sx[i+xoff] / 32767.0;
			else			/* and file is shorts */
				for (i = 0; i < xfrcnt; i++)
					sfd->sb[i+ssib] = sx[i+xoff];
		cvtd += xfrcnt;
		sfd->fs = max (sfd->fs, (st+cvtd));
	}

	sfd->bdir = SFWRITE;
	return (ns);
}

/*
 * note 1 - a file can grow by writeing with st == sfd->fs, i.e., tacking
 * samples onto the current end.  However, you may not write starting
 * beyond the end of the file, otherwise the value of the intervening
 * samples would be undefined.  A realtime file can be made to grow out to
 * the end of the cylinder block allocated when the file was created.  A
 * non-realtime file can grow arbitrarily out to the limit of the
 * available disk blocks.
 */

/*
 *  note 2 - if a file is open only for "w" writing, it may only be
 *  extended, i.e., every call to sndo must have st == sfd->fs as set by
 *  the last call to sndo (sndo updates sfd->fs automatically for every
 *  call).  If a file is open for "rw" read/write, samples can be written
 *  in it anywhere.  There is the overhead of an additional read of each
 *  buffer before it is written in this mode, however, so use it only
 *  where needed.
 */
