/* seeksf.c	1.1	(CARL)	7/25/84	13:44:00 */
#include <stdio.h>
#include <carl/libsf.h>


/*
 * seeksf takes an sfd and an offset in bytes and does a deferred seek.
 * This routine is the non-realtime companion to cylseek().  Seeks are
 * always done relative to the beginning of the file.  offset=0 gets you
 * to start of file.
 */

long    seeksf (sfd, offset)
struct sndesc  *sfd;
long    offset;
{
	extern long	cyltrns();
	extern long    lseek ();
	register long   vircyl,
	                bytoff,
	                cyloff,
	                n;

	if (offset < 0 || offset > sfd -> fs * sfd -> ssize) {
		sfd -> err = SFBNDER;
		return (-1);
	}
	vircyl = offset / sfd -> blksiz; /* virtual cylinder relative to base */
	bytoff = offset % sfd -> blksiz;/* byte offset from cyl */
	cyloff = cyltrns (sfd, vircyl);/* translate to actual cylinder */
	n = lseek (sfd -> fid, cyloff * sfd -> blksiz + bytoff, 0);
				/* go to byte */
	if (n < 0) {
		perror ("seeksf:lseek");
		sfd -> err |= SFBNDER;
		return (-1);
	}
	return (offset);
}
