/* panic.c	1.1	(CARL)	7/25/84	13:43:39 */
#include <stdio.h>
#include <carl/libsf.h>
#include <signal.h>

char   *tname = "sndXXXXXX";
char   *coredir = COREDIR;
char   *corename = "core";
extern char    *sfmyname;

panic () 
{
	extern char *mktemp();

	if (sfmyname != NULL) {
		char    buf[128];
		(void) sprintf (buf, "%s: panic: dumping core\n", sfmyname);
		report (buf);
	}
	if ((fork ()) == 0) {
		(void) setuid (geteuid ());/* make us su'ed to disk again */
		if (sfmyname != NULL)
			fprintf (stderr, "%s: dumping core in %s\n", sfmyname,
				coredir);
		if (chdir (coredir) == -1) {
			perror("chdir");
			fprintf (stderr, "panic: chdir failed\n");
		}
		if (access (corename, 0) == 0) {
			if (link (corename, mktemp (tname)) == -1)
				fprintf (stderr, "panic: link failed\n");
			if (unlink (corename) == -1)
				fprintf (stderr, "panic: unlink failed\n");
		}
		catchall (SIG_DFL);
		abort ();
	}
}
