/* opensf.c	1.3	(CARL)	9/10/84	11:54:29 */
#include<stdio.h>
#include<carl/libsf.h>

/*
 * User-level proc. to open a sound file.  It
 * calls popen() to invoke the user command opensf to open the file.
 * and sends the name of the file to be opened and gets back the
 * text version of the opened sdf file.
 * opensf is a set-user-id program that has write permission on the
 * sdf directory.  opensf() can thus be called in a program that does
 * not have such permission to still access sound files.
 *
 * To open a file this way,
 *	name = (possibly partial) filename spec
 *	flags = a string of flags to the program opensf, which include
 *		-r 	= read
 *		-w 	= write
 *		-r -w 	= readwrite
 *		-s 	= share
 * This last flag is trapped in opensf() the routine, as an indication that
 * the user would like to share open sound file descriptors.  Thus, if there
 * is an open sfd on this file already, opensf() returns a pointer to it
 * instead of creating another sfd.  This is analogous to UNIX's reopen()
 * function.
 */

extern struct sndesc   *rootsfd;
extern int      sferror;
extern int     sfbufsiz;	/* from getsfbuf */

extern int      nlrsdf;		/* imported from rsdf() */

struct sndesc  *
opensf (name, flags)
	char   *name,
	       *flags;
{
	extern char *index();
	int     sfquitit ();
	char    buf[BUFSIZ],
	       *getsfile (), *tmp;
	FILE * pp, *popen ();
	struct sndesc  *rsdf (), *sfd, *sfsearch ();
	struct sfstab  *sfs,
	               *dirinfo ();

	sferror = 0;		/* a clean slate */

	if (index (flags, 's') != NULL) {/* wants to share sfd's */
		sfd = sfsearch (name);
		if (sfd != 0)
			goto gotit;
	/* else continue with the open */
	}
	(void) sprintf (buf, "opensf %s %s", flags, name);
	pp = popen (buf, "r");
	if (pp == NULL) {
		fprintf (stderr, "plumbing is leaking!");
		sferror = IOER;
		return (NULL);
	}
	setsfile (name);
	tmp = getsfile ((char *) NULL);
	nlrsdf = 1;
	sfd = rsdf (pp, tmp);
	nlrsdf = 0;
	if (sfd == NULL || sferror != 0) {
		fprintf (stderr, "opensf: error reading %s\n", name);
		return (NULL);
	}
	free (tmp);
	(void) pclose (pp);
	if (sfd == NULL)
		return (NULL);

 /* open disk in raw mode according to rw */
	if ((sfs = dirinfo (sfd -> sfn)) == NULL) {
		fprintf (stderr, "opensf: error reading %s\n", SFSTAB);
		sferror = IOER;
		return (NULL);
	}
	if (chdir(sfs -> sdfdir) == -1) {
		perror("chdir");
		sferror = IOER;
		return (NULL);
	}
	if ((sfd -> fid = getrfid (sfs, sfd -> rw)) < 0) {
		perror ("opensf");
		fprintf (stderr, "opensf: can't open %s\n", sfs -> snddev);
		sferror = IOER;
		return (NULL);
	}
	if (sfbufsiz == 0)
		sfd -> bufsiz = sfs -> bsize;/* bytes per buffer */
	else
		sfd -> bufsiz = sfbufsiz;/* use buffer size override */
	sfd -> blksiz = sfs -> bpblock;
	catchall (sfquitit);	/* interrupt handler */
	linksfd (sfd);		/* linked list of all open sound files */

gotit: 	return (sfd);
}

CSNDFILE * sfsearch (name)
char   *name;
{
	CSNDFILE * x;
	char   *fname,
	       *getsfn ();
	fname = getsfn (name, 0);/* return full filename */
	for (x = rootsfd; x != NULL; x = x -> nxtsdf) {
		if (!strcmp (fname, x -> sfn))
			break;
	}
	free (fname);
	return (x);
}

/*
 * main(argc, argv)
 * 	char **argv;
 * {
 * 	struct sndesc *popensf(), *sfd;
 * 
 * 	if (argc < 2) exit(-1);
 * 
 * 	sfd = opensf(argv[1], "r");
 * 
 * 	psdf(stdout, sfd);
 * 
 * 	exit(0);
 * 	}
 */
