/* lockfopen.c	1.1	(CARL)	7/25/84	13:43:16 */
#include <sys/file.h>
#include <errno.h>
#include<stdio.h> 
#include <carl/libsf.h> 
#include<sys/types.h>
#include<sys/stat.h>

#ifdef DEBUG
extern long     getpid ();
extern int      interlock;
#endif DEBUG

FILE *
lockfopen (file, mode)
char   *file,
       *mode;
{
	FILE * fid;

 /* try to open it */
	if ((fid = fopen (file, mode)) == NULL)
		return (NULL);

	if (lockfid (fid) < 0) {
		fprintf (stderr, "lockfopen: error locking %s\n", file);
		(void) fclose (fid);
		return (NULL);
	}
	return (fid);
}

lockfid (fid)
FILE * fid;
{
	extern int errno;
	int     cnt = 0;

	while (flock (fileno (fid), LOCK_EX | LOCK_NB) != 0) {
		if (errno == EWOULDBLOCK) {
			if (cnt++ > SF_LOCK_TIMEOUT) {
				fprintf (stderr, "lockfid: timeout\n");
				return (-1);
			}
			else {
#ifdef DEBUG
				if (interlock)
					if (cnt == 1)
						fprintf (stderr, 
						    "lockfid: %d sleeping\n", 
						    getpid ());
#endif DEBUG
				sleep (1);
			}
		}
		else {
			(void) fclose (fid);
			perror ("lockfid");
			return (-1);
		}
	}
#ifdef DEBUG
	if (interlock) {
		if (cnt != 0)
			fprintf (stderr, "lockfid: %d gotcha!\n", getpid ());
		else
			fprintf (stderr, "lockfid: %d locking\n", getpid ());
	}
#endif DEBUG
	return (0);
}

lockfclose (fid)
	FILE * fid;
{

	if (unlockfid (fid) < 0)
		return (-1);
	if (fclose (fid) == EOF) {
		perror ("fclose");
		return (-1);
	}
	return (0);
}

unlockfid (fid)
FILE * fid;
{
#ifdef DEBUG
	if (interlock)
		fprintf (stderr, "unlockfid: %d unlocking\n", getpid ());
#endif DEBUG
	if (flock (fileno (fid), LOCK_UN) != 0) {
		perror ("flock");
		return (-1);
	}
	return (0);
}

/*
 * main(argc, argv)
 * 	char **argv;
 * {
 * 	FILE *fid;
 * 
 * 	if (argc < 2)
 * 		exit(1);
 * 
 * 	if ((fid = lockfopen(argv[1], "r")) == NULL) {
 * 		fprintf(stderr, "lockfopen failed\n");
 * 		exit(1);
 * 	}
 * 	sleep(SF_LOCK_TIMEOUT);
 * 	if (lockfclose(fid) < 0) {
 * 		fprintf(stderr, "lockfclose failed\n");
 * 		exit(1);
 * 	}
 * 	exit(0);
 * }
 */
