/* cylcp.c	1.1	(CARL)	7/25/84	13:42:00 */
#include <stdio.h>
#include <carl/libsf.h>
extern char *malloc(), *calloc(), *realloc();

/* 
 * cylcp - copy a disk block consisting of units of cylinders,
 * takes:
 * 	from - the first source cylinder, 
 *	to - the first destination cylinder,
 * 	len - howmany cylinders. 
 *	bptrack - size of track in bytes
 *	bpcyl - size of cylinder in bytes
 */

long
cylcp (ifid, ofid, from, to, len, bptrack, bpcyl)
int     ifid,
        ofid;
long    from,
        to,
        len;
int     bptrack;
long    bpcyl;
{
	extern long    lseek ();
	char   *buf;
	register long   i,
	                j,
	                n;

	if (bptrack <= 0 || bpcyl <= 0 || len <= 0)
		return (-1);

	if ((buf = malloc ((unsigned) (bptrack * sizeof(char)))) == NULL)
		malerr("cylcp", 1);

	for (i = from * bpcyl, j = to * bpcyl;
			i < (from + len) * bpcyl;
			i += bptrack, j += bptrack) {
	/* read from */
		n = lseek (ifid, i, 0);
		if (n < 0) {
			perror ("lseek");
			return (n);
		}
		if ((n = read (ifid, buf, bptrack)) != bptrack) {
			perror ("read");
			return (n);
		}
	/* write to */
		n = lseek (ofid, j, 0);
		if (n < 0) {
			perror ("lseek");
			return (n);
		}
		if ((n = write (ofid, buf, bptrack)) != bptrack) {
			perror ("read");
			return (n);
		}
	}
	free (buf);
	return (0);
}
