h39778
s 00005/00000/00107
d D 1.3 84/11/19 14:48:09 root 3 2
c now prints out the contents of cprop subfield on sndesc.
e
s 00012/00001/00095
d D 1.2 84/09/09 23:56:59 disk 2 1
c fixes to accomodate very long file names
e
s 00096/00000/00000
d D 1.1 84/07/25 13:45:16 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
I 2
#include <sys/types.h>
#include <sys/dir.h>
E 2
#include <stdio.h>
#include <carl/libsf.h>

/*
 * wsdf - write a sound descriptor file.
 * This routine takes an optional file pointer to a file open for writing.
 * If none is supplied, the file named in sdp->sfn, with SDFEXT attached,
 * is opened for writing.  
 */

extern  FILE * lockfopen ();
int	nlwsdf;		/* external in closesf() */

wsdf (fp, sdp)
	FILE *fp;
	struct sndesc  *sdp;
{
	extern char *strcat();
	extern char *strcpy();
	int     closeit = 0;
	struct dskblk  *cp;
	struct inclist *inc;
	struct comlist *com;
	FILE * fopen ();
I 3
	struct csnd_prop *pro;
E 3

	if (sdp == NULL)
		return (-1);

	if (fp == NULL) {
D 2
		char    name[32];
E 2
I 2
		extern	char *malloc();
		char    *name;

E 2
		if (sdp -> sfn == NULL || !strlen (sdp -> sfn)) {
			return (-1);
		}
		else {
I 2
			name = malloc (strlen(sdp -> sfn) + strlen(SDFEXT) + 1);
			if (name == NULL) {
				fprintf (stderr, "wsdf: malloc failed\n");
				return (-1);
			}
E 2
			(void) strcpy (name, sdp -> sfn);
			(void) strcat (name, SDFEXT);
		}
		(void) umask (~(0664));
		if ((fp = lockfopen (name, "w")) == NULL) {
			fprintf (stderr, 
			    "wsdf: error opening file %s\n", name);
I 2
			(void) free (name);
E 2
			return (-1);
		}
		closeit = 1;
I 2
		(void) free (name);
E 2
	}

	/* write first 4 variables */
	fprintf (fp, "%c %c\n%c %d\n%c %o\n%c %c\n",
		FRTFLAG, sdp -> rtflag,
		FNCYLS, sdp -> ncyls,
		FPROT, sdp -> fprot,
		FHOLD, sdp -> fhold == '\0' ? SCRAT : sdp -> fhold);

	if (sdp -> rw != SFCLOSED) {
		fprintf (fp, "%c ", FRW);
		if (sdp -> rw & SFREAD)
			fprintf (fp, "%c", SRWR);
		if (sdp -> rw & SFWRITE)
			fprintf (fp, "%c", SRWW);
		fprintf (fp, "\n");
		fprintf (fp, "%c %d\n", FPID, sdp -> spid);
	}

	/* write name and owner */
	fprintf (fp, "%c %s\n%c %s\n", FSFN, sdp -> sfn, FSFOWN, sdp -> sfown);

	/* write cylinder blocks */
	for (cp = sdp -> cp; cp != NULL; cp = cp -> next)
		fprintf (fp, "%c %c\t%d\t%d\t%d\n",
		    FCP, cp -> flag, cp -> base, cp -> len, cp -> seq);

	/* write sample parameters */
	fprintf (fp,
	    "%c %f\n%c %c\n%c %u\n%c %d\n%c %u\n%c %u\n%c %u\n%c %u\n%c %u\n",
	    FSR, sdp -> sr, FPM, sdp -> pm, FNC, sdp -> nc, FFS, sdp -> fs,
	    FCD, sdp -> cdate, FRD, sdp -> rdate, FAD, sdp -> adate,
	    FDD, sdp -> dumpd, FTK, sdp -> tpkey);

	/* write comment strings */
	for (com = sdp -> comsdf; com != NULL; com = com -> comnext)
		fprintf (fp, "%c %s\n", FREM, com -> cmt);

	/* write include file strings */
	for (inc = sdp -> inclsdf; inc != NULL; inc = inc -> incnext)
		fprintf (fp, "%c %s\n", FINC, inc -> fn);
I 3

	for (pro = sdp->csnd_p; pro != NULL; pro = pro->cprop_next)
		fprintf(fp, "%c %s %s\n", FPROP, pro->cprop_name,
		    pro->cprop_val);
E 3

	if (closeit)
		if (lockfclose (fp) < 0) {
			fprintf(stderr, "wsdf: lockfclose failed\n");
			return (-1);
		}

	sync ();		/* flush system buffers */
	return (0);
}
E 1
