h13413
s 00063/00000/00000
d D 1.1 84/07/25 13:44:58 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/libsf.h>

trim (head, sfd)
struct dskblk  *head;
struct sndesc  *sfd;
{
	extern struct dskblk *makenode();
	struct dskblk  *p,
	               *q;	/* points to link on sfd */
	long int        blksum,
	                len,
	                blklen;

 /* is there anything there to trim? */
	if (sfd -> fs <= 0)
		return (0);
 /* figure out size of file in grains */
 /* get cyl. len. of file */
	len = sfd->fs * (sfd->pm == PM16BIT ? sizeof (short) : sizeof (float));
	blklen = len / sfd -> blksiz;
	if ((len - (blklen * sfd -> blksiz)) > 0)/* round up */
		blklen += 1;
	if (blklen == 0)
		blklen = 1;	/* need to claim one at least */
	if (sfd -> cp == NULL) {
		fprintf(stderr, "trim: no block list\n");
		return(-1);
	}
	for (p = sfd -> cp, blksum = 0; p != NULL; p = p -> next) {
		blksum += p -> len;
		if (blksum >= blklen)
			break;	/* p points to block to be trimmed */
	}
	if (p == NULL) {		/* hopefully impossible */
		fprintf(stderr, 
 		    "trim: failed finding block. blksum=%d, blklen=%d\n",
			blksum, blklen);
		return (-1);
	}
	blksum -= p -> len;	/* now == all preceeding blocks length */
	len = blklen - blksum;	/* remaining part of this block that's
				   used */
 /* break up partially used block */
	for (q = head; q != NULL; q = q -> next) {/* find on free list */
		if (p -> base == q -> base)
			break;
	}
	if (q -> len - len > 0) {/* create new blk */
		if (makenode (q, q -> next, q -> base + len,
		    q -> len - len, UNUSED, "none", NULL, 0, -1) == NULL) {
			fprintf(stderr, "trim: makenode failed\n");
			return (-1);
		}
		q -> len = len;	/* trim this block on free list */
		p -> len = len;	/* trim this block on file descriptor */
	}
 /* look for any remaining claimed, but unused blocks */
	for (p = p -> next; p != NULL; p = p -> next)
		p -> flag = UNUSED;
	return (0);
}
E 1
