h31645
s 00009/00003/00082
d D 1.2 84/09/09 23:56:55 disk 2 1
c fixes to accomodate very long file names
e
s 00085/00000/00000
d D 1.1 84/07/25 13:43:53 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/libsf.h>

/*
 * rsdf - read in a sound descriptor file.
 * This routine reads up the named descriptor file into a sndesc structure.
 * It sets sferror to SFDER if the sdf file is incompleat, and to READSFER
 * if it failed to read.
 */

extern int      sferror;

extern int      sfdstat;	/* from setsfd() */

int     nlrsdf;			/* published to opensf() and closesf the
				   program */

extern  FILE * lockfopen ();

struct sndesc  *
rsdf (fp, name)
	FILE * fp;
	char   *name;
{
	extern char *rindex (), *strcpy(), *strcat();
	extern struct sndesc *setsfd ();
	extern struct dskblk  *addcp ();
	struct sndesc  *sfd = NULL;
	char    buf[BUFSIZ],
	       *bufp1 = buf + 1,
	       *bufp2 = buf + 2;
	char   *nl;
	int     closeit = 0;

	if (name == NULL && !nlrsdf)
		return (NULL);

	if (fp == NULL) {
D 2
		char    nb[32],
		       *rindex ();
		register char  *c;
E 2
I 2
		extern char	*rindex ();
		extern char	*malloc ();
		register char	*nb;
		register char	*c;
E 2

I 2
		nb = malloc (strlen(name) + strlen(SDFEXT) + 1);
		if (nb == NULL) {
			fprintf (stderr, "rsdf: malloc failed\n");
			return (NULL);
		}
E 2
		(void) strcpy (nb, name);
		c = rindex (name, '.');
		if (!(c != NULL && !strcmp (SDFEXT, c)))
				/* already has suffix */
			(void) strcat (nb, SDFEXT);
		if ((fp = lockfopen (nb, "r")) == NULL)
			return (NULL);
		closeit++;
	}

	sfdstat = 0;		/* reset to trap insufficient sfd spec */

	while (fgets (buf, BUFSIZ, fp) != NULL) {
		*bufp1 = NULL;
		if (*buf == FCP) {/*  cp - cylinder pointer list */
			if (addcp (sfd, bufp2) == NULL) {
				sferror = READSFER;
				return (NULL);
			}
		}
		else {
			nl = rindex (bufp2, '\n');/* zap the \n */
			if (nl != NULL)
				*nl = NULL;
			if ((sfd = setsfd (sfd, buf, bufp2)) == NULL) {
				sferror = READSFER;
				return (NULL);
			}
		}
	}
	if (closeit)
		if (lockfclose (fp) != 0) {
			fprintf(stderr, "rsdf: lockfclose failed\n");
			return(NULL);
		}

	if (sfdsetok () != 0) {
		sferror = SFDER;
		return (NULL);
	}
	return (sfd);
}
E 1
