h34731
s 00005/00002/00127
d D 1.3 85/04/25 15:23:32 dgl 3 2
c 
e
s 00005/00002/00124
d D 1.2 85/04/15 11:15:10 dgl 2 1
c Now checks for fd returned from lockfopen.
e
s 00126/00000/00000
d D 1.1 84/07/25 13:43:27 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <sys/file.h>
#include <carl/libsf.h>
extern char *malloc(), *calloc(), *realloc();

/*
 * mlock - masterlock sound file system.  Use of this allows an equivalent
 * to single user mode for unix, and also provides a way to halt all sound
 * i/o when a particularly disasterous event occurrs.  The routines mlock()
 * and munlock() manage the file MASTERLOCK, which, when it exists, causes
 * all regular calls to lock() to fail, unless the user is a SUPERGROUPie,
 * or unless the process calls lock() with FORCE!=0.  Closesf() calls lock()
 * with FORCE so as to allow all i/o to terminate before being masterlocked.
 * Once masterlocked, lock() prints the string message in the MASTERLOCK
 * file which can be either a notice from the SUPERUSER that the system is
 * down (done by running the program locksf), or an error generated by
 * a sound file program and reported as fatal.  The system will
 * continue to disallow all i/o until the MASTERLOCK file is 
 * removed by munlock(), or the running of the program unlocksf by a
 * SUPERGROUPie.
 */

extern  FILE * lockfopen ();

mlock (fs, msg, err)
char   *fs,
       *msg;
int     err;
{
D 2
	FILE * fopen (), *fd;
E 2
I 2
	FILE * lockfopen (), *fd;
E 2
	char   *masterlock,
	       *getsfile ();
	if (err || (ingroup (SUPERGROUP) == 1)) {
		setsfile (fs);
		masterlock = getsfile (MASTERLOCK);
		(void) umask (0);	/* let all write it who succeed this far */
D 2
		fd = lockfopen (masterlock, "w");
E 2
I 2
		if ((fd = lockfopen (masterlock, "w")) == NULL) {
			fprintf(stderr, "mlock: lockfopen of %s failed\n",
				masterlock);
I 3
			return(-1);
E 3
		}
E 2
		fprintf (fd, "%s\n", msg);
D 3
		if (fclose (fd) != 0)
E 3
I 3
		if (fclose (fd) != 0) {
E 3
			perror ("fclose");
I 3
			return(-1);
		}
E 3
		free (masterlock);
	}
	else {
		printf ("mlock: Sorry.\n");
D 3
		return (-1);
E 3
I 3
		return (1);
E 3
	}
	return (0);
}

munlock (fs)
char   *fs;
{
	char   *masterlock,
	       *getsfile ();
	if (ingroup (SUPERGROUP) == 1) {
		setsfile (fs);
		masterlock = getsfile (MASTERLOCK);
		if (access (masterlock, F_OK) == 0)
			if (unlink (masterlock)) {
				perror("unlink");
				fprintf (stderr, "munlock: can't unlock %s\n", 
					masterlock);
				return (-1);
			}
		free (masterlock);
	}
	else
		printf ("munlock: Sorry.\n");
	return (0);
}


/*
 * ismlocked - tests whether the system is masterlocked or not.
 * returns 0 for not locked, -1 for locked and requestor is
 * not in superuser group,
 * 1 for locked and requestor is in superuser group.
 */

ismlocked (fs)
char   *fs;
{
	char   *masterlock,
	       *getsfile ();

	setsfile (fs);
	masterlock = getsfile (MASTERLOCK);

	if (!access (masterlock, 0)) {/* masterlock file exists */
		if (ingroup (SUPERGROUP) == 1)/* are we superusers? */
			return (1);/* yes, but say it is mlocked */
		else		/* just regular guys */
			return (-1);/* say it is unavailable */
	}
	return (0);
}


/*
 * getmlokmsg - returns first line of masterlock file, returns NULL if
 * file not there, unopenable, or unreadable, else returns the text up
 * to the first '\n' or 256 characters. 
 * User must free the string returned when done.
 */

char   *getmlokmsg (fs)
char   *fs;
{
	FILE * fopen (), *fd;
	char   *msg,
	       *masterlock,
	       *getsfile ();

	setsfile (fs);
	masterlock = getsfile (MASTERLOCK);
	if ((fd = fopen (masterlock, "r")) == NULL)
		return (NULL);
	if ((msg = (char *) malloc (256)) == NULL)
		return (NULL);
	if (fgets (msg, 256, fd) != NULL)
		return (NULL);
	if (fclose (fd) < 0)
		perror ("fclose");
	return (msg);
}
E 1
