h57407
s 00001/00001/00049
d D 1.2 84/09/18 23:14:09 root 2 1
c fixed bug in check for writeability
e
s 00050/00000/00000
d D 1.1 84/07/25 13:42:49 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/libsf.h>

/*
 * take filename (can be partial name) and rw mode request, find the
 * appropriate raw device that goes with that raw device and open in
 * in the requested mode, after checking that it is not disabled.
 * Currently, an 'x' in either field in the devmode field of sfstab will
 * kill a request either for reading or writing.  It really ought to be
 * 	if (sfs->devmode[0] == 'x') /1* not open for reading *1/
 * 	if (sfs->devmode[1] == 'x') /1* not open for writing *1/
 * but I'm lazy.
 */

getrawdev (filename, rw)
char   *filename;
int     rw;
{
	extern char *index();
	char   *sfile,
	       *getsfile ();
	int     fid;
	struct sfstab  *dirinfo (), *sfs;

	setsfile (filename);
	sfile = getsfile ((char *) NULL);	/* just get device */
	if ((sfs = dirinfo (sfile)) == NULL) {
		fprintf (stderr, "getrawdev: error reading %s\n", SFSTAB);
		return (-1);
	}
	free (sfile);
	if (index (sfs -> devmode, 'x') != NULL) {
		fprintf (stderr, 
			"getrawdev: device %s disabled\n", 
			sfs -> sdfdir);
		return (-1);
	}
D 2
	if (rw > 0 && index (sfs -> devmode, 'w') != NULL) {
E 2
I 2
	if (rw > 0 && index (sfs -> devmode, 'w') == NULL) {
E 2
		fprintf (stderr, 
			"getrawdev: %s writing disabled\n", 
			sfs -> sdfdir);
		return (-1);
	}
	if ((fid = open (sfs -> snddev, rw, 0644)) < 0) {
		perror ("getrawdev:open");
		return (-1);
	}
	return (fid);
}
E 1
