h06749
s 00033/00000/00000
d D 1.1 84/07/25 13:42:02 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/libsf.h>


/*
 * Take an sfd and a virtual cylinder number and translate that to a
 * hardware cylinder number.  Virtual cylinders are numbered 0..N-1.  The
 * translation is simple for contiguous (realtime) files since there is
 * only one cylinder block.  For non-contiguous files, the virtual
 * cylinder must be found by walking the cylinder block list pointed to by
 * sfd->cp.
 */

long    cyltrns (sfd, vcyl)
struct sndesc  *sfd;
long    vcyl;
{
	struct dskblk  *p;
	long    blksiz;

	if (sfd -> rtflag == RT)
		return (sfd -> cp -> base + vcyl);

	if ((p = sfd -> cp) == NULL)
		return (-1);
	for (blksiz = p -> len; vcyl >= blksiz; blksiz = p -> len) {
		vcyl -= blksiz;
		if ((p = p -> next) == NULL)
			return (-1);
	}
	return (p -> base + vcyl);
}
E 1
