h13079
s 00038/00000/00000
d D 1.1 84/07/25 13:41:53 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include<stdio.h>
#include<carl/sndio.h>

/*
 * User-level proc. to close a sound file opened with opensf().  It
 * calls popen() to invoke the user command closesf to close the file,
 * and sends the text version of the file descriptor to closesf.
 * closesf is a set-user-id program that has write permission on the
 * sdf directory.  closesf() can thus be called in a program that does
 * not have such permission to still access sound files.
 */

extern int      sferror;

closesf (sfd)
struct sndesc  *sfd;
{
	char   *buf = "closesf";
	FILE * pp, *popen ();

	pp = popen (buf, "w");
	if (pp == NULL) {
		fprintf (stderr, "popen failed\n");
		sferror = IOER;
		return (-1);
	}

	if (wsdf (pp, sfd)) {
		fprintf (stderr, "closesf: wsdf failed\n");
		sferror = IOER;
		return (-1);
	}

	(void) pclose (pp);
	sferror = 0;		/* reset for next guy */
	return (0);
}
E 1
