h08586
s 00055/00000/00000
d D 1.1 84/07/25 13:41:44 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/libsf.h>

/* 
 * checksfd - validate an open sound file.  These conditions must be
 * met before an sfd can be used in a call to sndo() or sndi().   
 * The routine is called by creatsf() and opensf().
 * The routine returns -1 if can't read sfd at all, otherwise it returns
 * an error code, which it also deposits in sfd->err.
 * Fields checked are:
 * sound file name (sfn)
 * /1* number of channels (nc) is no longer checked *1/
 * sampling rate (sr)
 * packing mode (pm)
 * realtime flag (rtflag).
 * Note that the checks for pm and rtflag determine that one mode or
 * the other is set, but not both.
 * Also note that there are a lot of things NOT checked, notably there is
 * no check for cylinder address consistency.
 * There is another check made by rsdf() that makes sure a minimum
 * set of fields has been specified.
 */

checksfd (sfd)
struct sndesc  *sfd;
{
	int     errz = 0;

	if (sfd == NULL) {
		fprintf(stderr, "checksfd: NULL descriptor\n");
		return (-1);	/* now THAT's an error!! */
	}
	if (sfd -> sfn == NULL) {
		fprintf(stderr, "checksfd: NULL filename\n");
		errz |= SFDER;
	}
	if (!strlen (sfd -> sfn)) {
		fprintf(stderr, "checksfd: 0-length filename\n");
		errz |= SFDER;
	}
	if (sfd -> sr <= 0.0) {
		fprintf(stderr, "checksfd: invalid sampling rate\n");
		errz |= SFDER;
	}
	if (!((sfd -> pm == PM16BIT) || (sfd -> pm == PMFLOAT))) {
		fprintf(stderr, "checksfd: invalid packing mode\n");
		errz |= SFDER;
	}
	if (!((sfd -> rtflag == RT) || (sfd -> rtflag == NRT))) {
		fprintf(stderr, "checksfd: invalid file mode\n");
		errz |= RTIOCONFLICT;
	}
	return (errz);
}
E 1
