h63771
s 00008/00002/00067
d D 1.3 85/01/09 23:33:52 dgl 3 2
c stopped trying to catch KILL and STOP signals, which only
c produced EINVAL for my pains.
e
s 00013/00003/00056
d D 1.2 84/08/06 16:17:09 disk 2 1
c elaborated comment at beginning
e
s 00059/00000/00000
d D 1.1 84/07/25 13:41:42 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <signal.h>

/*
D 2
 * catchall - forward all interrupts to the routine intstat().
E 2
I 2
 * catchall - forward interrupts to the routine in intfunc
 * Note, SIGINT is handled specially.
 * A call to ignall() preceeds calling catchall().
 * Ignall always sets intstat to whatever value SIGINT had before
 * being set to SIGIGN.  So:
 * 1) if the process is running in the background, ignall() sets SIGINT
 * to SIGIGN, and sets intstat to SIGIGN as well, so catchall() will 
 * cause it to remain as SIGIGN.
 * 2) if the process is running in the foreground, ignall() sets SIGINT
 * to SIGIGN, and sets intstat to SIG_DFL, so catchall() will 
 * set SIGINT to intfunc.
E 2
 */


D 2
int     (*intstat) ();
E 2
I 2
int     (*intstat) ();	/* published to ignall() */
E 2

catchall (intfunc)
D 2
int     (*intfunc) ();
E 2
I 2
	int     (*intfunc) ();
E 2
{
	if (intstat == SIG_DFL)
		(void) signal (SIGINT, intfunc);
	else
		(void) signal (SIGINT, intstat);
	(void) signal (SIGHUP, intfunc);
	(void) signal (SIGQUIT, intfunc);
	(void) signal (SIGILL, intfunc);
	(void) signal (SIGTRAP, intfunc);
	(void) signal (SIGIOT, intfunc);
	(void) signal (SIGEMT, intfunc);
	(void) signal (SIGFPE, intfunc);
I 3
#ifdef 	NOTDEF
	/* attempt to catch SIGKILL produces EINVAL */
E 3
	(void) signal (SIGKILL, intfunc);
I 3
#endif 	NOTDEF
E 3
	(void) signal (SIGBUS, intfunc);
	(void) signal (SIGSEGV, intfunc);
	(void) signal (SIGSYS, intfunc);
	(void) signal (SIGPIPE, intfunc);
D 3
/* skip SIGALRM, which is set elsewhere */
E 3
I 3
/* skip SIGALRM */
E 3
	(void) signal (SIGTERM, intfunc);
#ifdef	SIGSTOP	
I 3
#ifdef 	NOTDEF
	/* attempt to catch SIGSTOP produces EINVAL */
E 3
	(void) signal (SIGSTOP, SIG_DFL);
D 3
#endif
E 3
I 3
#endif 	NOTDEF
#endif	SIGSTOP
E 3
#ifdef	SIGTSTP 
	(void) signal (SIGTSTP, SIG_DFL);
#endif
#ifdef	SIGCONT 
	(void) signal (SIGCONT, SIG_DFL);
#endif
#ifdef	SIGCHLD 
	(void) signal (SIGCHLD, SIG_DFL);
#endif
#ifdef	SIGTTIN 
	(void) signal (SIGTTIN, SIG_DFL);
#endif
#ifdef	SIGTTOU 
	(void) signal (SIGTTOU, SIG_DFL);
#endif
#ifdef  SIGTINT 
	(void) signal (SIGTINT, SIG_DFL);
#endif
#ifdef	SIGXCPU	
	(void) signal (SIGXCPU, SIG_DFL);
#endif
#ifdef	SIGXFSZ 
	(void) signal (SIGXFSZ, SIG_DFL);
#endif
}
E 1
