h14087
s 00094/00000/00000
d D 1.1 84/07/25 14:19:20 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/libsf.h>

char *getsfn();

main(argc, argv)
	char **argv;
{
	extern char *strcat(), *strcpy();
	extern char *getprown();
	FILE  *fp;
	char namebuf[BUFSIZ], homebuf[BUFSIZ], *c, ch, 
		*homedir = NULL, *user = NULL;

	while ((ch = crack(argc, argv, "u|H|h", 0)) != '\0') {
		switch (ch) {
			case 'u':
				user = arg_option;
				break;
			case 'H':
				homedir = arg_option;
				break;
			case 'h':
				usage(0);
			default: 
				usage(1);
			}
	}

	(void) strcpy(namebuf, CDPREFIX);
	if (user == NULL)
		(void) strcat(namebuf, getprown());
	else {
		if (ingroup(SUPERGROUP) != 1) {
			fprintf(stderr, "Sorry, you may not use the -u flag\n");
			exit(1);
		}
		(void) strcat(namebuf, user);
	}

	if (argc == 1) {		/* change to home directory */
		(void) strcpy(homebuf, namebuf);
		(void) strcat(homebuf, ".H");
		if (access(homebuf, 0) == 0) {
			if (cp(homebuf, namebuf) != 0) {
				fprintf(stderr, "cdsf: cp failed\n");
				exit(1);
			}
		}
		exit(0);
	} else if (homedir != NULL) {	/* set up home directory */
		(void) strcat(namebuf, ".H");
	}				/* else cdsf to directory */
	if (homedir != NULL)
		c = homedir;
	else
  		c = getsfn(argv[arg_index], 0);
	if ((fp = fopen(namebuf, "w")) == NULL) {
		fprintf(stderr, "cdsf: can't open %s\n", namebuf);
		exit(1);
	}
	fprintf(fp, "%s", c);
	(void) fclose(fp);
	exit(0);
}

usage(x)
{
fprintf(stderr, "%s%s%s%s",
"usage: cdsf [flag] directory\n",
" flag:\n",
"\t-HX\tset up home directory where X is the directory name\n",
"\t-uX\tchange directory for user X (reserved for superuser)\n"
);
exit(x);
}

cp(hb, nb)
	char *hb, *nb;
{
	FILE *hp, *np;
	int c;

	if ((hp = fopen(hb, "r")) == NULL)
		return(-1);
	if ((np = fopen(nb, "w")) == NULL)
		return(-1);
	while ((c = getc(hp)) != EOF)
		putc(c, np);
	(void) fclose(hp);
	(void) fclose(np);
	return(0);
}
E 1
