h40540
s 00003/00007/00266
d D 1.2 84/09/10 23:32:31 root 2 1
c output file now defaults to contiguous, even if first input 
c file is contiguous.  This fixes a bug where catsf'ing from a large-block 
c filesystem to a small-block one causes contiguous files to bomb, since 
c they can't expand beyond the count of cylinders of the source file, but 
c must, since the cylinders are smaller.
e
s 00273/00000/00000
d D 1.1 84/07/25 14:19:10 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/libsf.h>

extern int sferror;  /* from sopensf */

/* see note at bottom */

int verbose=0;
char *oname = NULL;
#define MAXFILES 128
int files[MAXFILES];
int repeats[MAXFILES];
D 2
int cmdfile, contiguous, noncontiguous;
E 2
I 2
int cmdfile, contiguous;
E 2
char *cmdfiles[MAXFILES];

struct sndesc **isfd;

main(argc, argv)
    	int argc; char *argv[];
{
    extern char *malloc(), *strcpy();
    struct sndesc *osfd=NULL, *tsfd=NULL, *xsfd=NULL,
	*sopensf(), *cpsfd(), *setsfd();
    int i=0, n, error;
    long olen=0, obyts;

    sfsetiname(argv[0]);		/* pass name to interrupt routines */

    n = catparse(argc, argv)-1;		/* n == # input files */

    oname = argv[files[n]];		

    if (!isatty(0))			/* read a command file */
	{
	extern char *gets();
	char buf[128], *index();

	n = 0;
	while(gets(buf) != NULL)
		{
		if (!strlen(buf))
			continue;
		cmdfiles[n] = (char *) malloc((unsigned) strlen(buf)+1);
		(void) strcpy(cmdfiles[n++], buf);
		if (n >= MAXFILES)
			{
			fprintf(stderr, "catsf: too many files, limit is: %d\n",
				MAXFILES);
			exit(1);
			}
		}
	cmdfile++;
	}

    for (i = 0; i < n; i++)
	{
	if (!cmdfile)
	    {
	    if (!strcmp(oname, argv[files[i]]))
		{
		fprintf(stderr, "catsf: input name: %s same as output: %s\n",
		    argv[files[i]], oname);
		exit(1);
		}
	    }
	else
	    {
	    if (!strcmp(oname, cmdfiles[i]))
		{
		fprintf(stderr, "catsf: input name: %s same as output: %s\n",
		    cmdfiles[i], oname);
		exit(1);
		}
	    }
	}

    isfd = (struct sndesc **) malloc((unsigned) sizeof(struct sndesc *) * n);

    for (i = 0; i < n; i++)	/* now that they're blessed, open them */
	{
	if (!cmdfile)
	    {
	    if ((xsfd = sopensf(argv[files[i]], "r", (struct sndesc *) NULL)) 
		== NULL)
		{
		fprintf(stderr, "sopensf failed on %s\n", argv[files[i]]);
		goto quit;
		}
	    }
	else
	    {
	    if ((xsfd = sopensf(cmdfiles[i], "r", NULL)) == NULL)
		{
		fprintf(stderr, "sopensf failed on %s\n", cmdfiles[i]);
		goto quit;
		}
	    }
	isfd[i] = xsfd;
	olen += isfd[i]->fs * repeats[i];
	}
    for (error = 0, i = 1; i < n; i++)	/* check them for catability */
	{
	if (isfd[i]->pm != isfd[0]->pm)
	    {
	    fprintf(stderr, "catsf: packing mode conflict between %s and %s\n",
		isfd[0]->sfn, isfd[i]->sfn);
	    error++;
	    }
	if (isfd[i]->nc != isfd[0]->nc)
	    {
	    fprintf(stderr, "catsf: # channels conflict between %s and %s\n",
		isfd[0]->sfn, isfd[i]->sfn);
	    error++;
	    }
	}
    if (error) 
	goto quit;

    /* output file will have attributes of first input file */
    tsfd = cpsfd(isfd[0]);		/* copy the input sfd */
    tsfd = setsfd(tsfd, "f", oname);	/* change name to output file */
    if (contiguous)
	tsfd = setsfd(tsfd, "t", "r");	/* force it to be contiguous */
D 2
    else if (noncontiguous)
E 2
I 2
    else 
E 2
	tsfd = setsfd(tsfd, "t", "n");	/* force it to be non-contiguous */
    obyts = olen * isfd[0]->ssize;	/* output file size in bytes */
    tsfd->ncyls=(obyts/isfd[0]->blksiz) /* howmany cylinders will it need? */
	+((obyts%isfd[0]->blksiz)?1:0);	/* round up if necessary */
    osfd = sopensf((char *) NULL, "wF", tsfd);
    if (osfd == NULL) 
	{ 
	for (i = 0; i < n; i++)
	    sclosesf(isfd[i]); 
	exit(1); 
	}
    getsfbuf(osfd);

    for (i = 0; i < n; i++)		/* foreach file, do a copy */
	{	
	register long iblk, niblks;
	register int rem;
	char *x, *p, *shrt="s", *flt="f";

	getsfbuf(isfd[i]);
	niblks = isfd[i]->fs / isfd[i]->nsib;
	rem = isfd[i]->fs % isfd[i]->nsib;
	if (verbose) 
		printf("copying %s\n", isfd[i]->sfn);
	x = isfd[i]->pm == PM16BIT ? (char *) isfd[i]->sb :(char *) isfd[i]->fb;
	p = isfd[i]->pm == PM16BIT ? shrt : flt;
	for (iblk = 0; iblk < niblks; iblk++) {
	    filsfb(isfd[i], iblk);		/* fill input buffer */
	    if (sndo(osfd, x, osfd->fs, isfd[i]->nsib, p) < 0) {
		fprintf(stderr, "catsf: sndo error 1\n");
		goto quit;
	    }
	}
	if (rem != 0) {
	    filsfb(isfd[i], niblks);
	    if (sndo(osfd, x, osfd->fs, rem, p) < 0) {
		fprintf(stderr, "catsf: sndo error 2\n");
		goto quit;
	    }
	}
	if (repeats[i] > 1) 
		{ repeats[i]--; i--; }	/* do it again */
	else
		stunsf(isfd[i]);	/* done with this file */
	}
    osfd->fs = olen;	/* final val may be less than running figure */
    if (ssfallclose() != 0)
	exit(1);
    exit(0);
quit:
    fprintf(stderr, "catsf: aborting\n");
    ssfallclose();
    exit(1);
}

catparse(argc, argv)
	int argc; char **argv;
{
char *index(), flag, *option;
register int i, j;
float sfexpr();

for (i = 0; i < MAXFILES; i++) repeats[i]=1;

for (i = 1, j = 0; i < argc; i++)
	if (*argv[i] == '-')	/* itsa flag */
		{
		flag = *(argv[i]+1);
		option = argv[i]+2;
		if (flag == 'r')	/* itsa repeat */
			repeats[j] = sfexpr(option, 1.0);
		else
		if (flag == 'c')	/* contiguous file? */
			contiguous++;
		else
D 2
		if (flag == 'n')	/* non-contiguous file? */
			noncontiguous++;
		else
E 2
		if (flag == 'v')	/* verbosity */
			verbose++;
		else
		if (flag == 'h')	/* wants some help */
			cathelp();
		else
			{
			fprintf(stderr, "illegal flag: %s\n", argv[i]);
			exit(1);
			}
		}
	else
		/* itsa file */
		files[j++] = i;	/* we'll use this to index argv */
return(j);
}

cathelp()
{
D 2
	printf("%s%s%s%s%s%s%s",
E 2
I 2
	printf("%s%s%s%s%s%s%s%s",
E 2
	    "usage: catsf [flags] [-rN] source [[-rN] source]... destination\n",
	    " flags:\n",
	    " -rN means repeat the next source N times\n",
	    " -c force file to be contiguous\n",
D 2
	    " -n force file to be non-contiguous\n",
E 2
	    " -fX read commands from file X\n",
	    " -v  makes catsf more verbose.\n");
	exit(1);
}

/*
 * catsf - concatenate sound files
 * Method:
 * open all input files, figure out how long output file must be
 * check for compatability of input files
 * 	can't have stereo and mono combined, 
 * 	sampling rates must agree,
 * 	packing modes must agree.
 * copy the sfd for input file 0 to form attributes of output file
 * 	force it to be a realtime file (could be optional)
 * 	change the name of the copied sfd to be the output file name
 * open the output file
 * loop through files concatenating.
 * 	some arcane things are done with the i/o operations:
 * 		filsfb() fills the input buffer for the current input
 * 		file with a block.
 * 		sndo() writes out that block, pointed to by x. 
 * 		The starting sample is equal to the number of output 
 * 		samples written so far, osfd->fs.
 * 		the number of samples is the size of the input buffer,
 * 		which is set up to be the same as the output buffer:
 * 		osfd->nsib.
 * 		finally, the argument p will either have "s" or "f" to
 * 		tell sndo() whether the buffer got by filsfb() contains
 * 		shorts or floats.
 *	the purpose of using filsfb(), not sndi(), is that we can always
 *	read raw blocks without alignment problems, and we also don't
 *	need to unpack shorts into floats, which means we also don't need to
 *	do the copy implied by moving sndi()'s input buffer to the array
 *	that normally interfaces to the user.  Avoiding these copies and
 *	floats/fixes saves an incredible amount of time.
 *	we must use sndo() instead of wrtsfb() to write it out because
 *	at the end of an input file, there may by a few samples in the last
 *	buffer, and we must align the next file to begin on the very next
 *	sample, which sndo() does, and wrtsfb() does not.
 *	the reason for explicitly managing buffers for sndo() is to be
 *	able to use the default size in calculating the transfer.
 *	for file input buffers, when we're done with the file, we're done
 *	with the buffer too, so stunsf() removes the buffer.
 */
E 1
