h27809
s 00402/00000/00000
d D 1.1 84/07/25 14:18:58 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/libsf.h>
#define SAVE 1
#define CYLCPTIME 4.0	/* 4 secs./cyl. max. observed disk latency */

/* for operation, see comment at bottom */

int debug = 0;

char *sfdevice, *alloc, *newalloc;
struct sfstab *sfs, *dirinfo();

main(argc, argv)
	int argc; char **argv;
{
    extern struct sndesc *sdfrdall(); 
    extern struct dskblk *sfrdfre(), *makenew(), *claim(), *match();
    extern char  *getsfile();
    char *dcb = "dskcyls.burp";
    extern long cylcp();
    long hits, dskblkcnt, curbase(), maxcyls, ycnt=0;
    int ifid, ofid;
    struct dskblk *old_head, *new_head, *dbp, *nbp; 
    int bptrack; 
    long bpcyl;

    if ((argc > 2) && (atoi(argv[2]) != 0)) 
	debug = 1;

    if (ingroup(SUPERGROUP)<1) {
	fprintf(stdout, "burpsf: sorry, you are not in the %s group.\n",
		SUPERGROUP);
	exit(1);
    }

    if (argc > 1) 
	setsfile(argv[1]);
    else 
	setsfile((char *) NULL);
    sfdevice = getsfile((char *) NULL);
    alloc = getsfile(ALLOCNAME);
    sfs = dirinfo(sfdevice);
    if (sfs == NULL) {
	fprintf(stderr, "sfgetfl: dirinfo failed\n"); 
	exit(1);
    }
    newalloc = getsfile(dcb);
    old_head = sfrdfre(sfdevice);
    hits = zapfree(old_head);
    if (hits < 0) {
	fprintf(stderr, "zapfree: error coalescing free blocks.\n");
	exit(1);
    }
    printf("creating disk image, stand by\n");
    if (sdfrdall(old_head, &dskblkcnt) == NULL) {
	fprintf(stderr, "sdfrdall failed\n");
	exit(1);
    }
    maxcyls = sfs->devlen;
    bptrack = sfs->bsize;
    bpcyl = sfs->bpblock;
    if ((new_head = makenew(maxcyls)) == NULL) {
	fprintf(stderr, "burpsf: error making new free list.\n");
	exit(1);
    }

    /* remove old cylinder blocks from sfd's except for badblocks */
    for (dbp = old_head; dbp->flag != EOLIST; dbp = dbp->next) {
	if (dbp->flag == USED) {
	    if (badblk(dbp->dfn)) 
		continue;
	    delink(dbp->dsksfd->cp);
	    dbp->dsksfd->cp = NULL;	/* plant silver stake in its heart */
	}				/* but don't reset ncyls */
    }

    /* first, claim cyls occupied by bad blocks */
    for (dbp = old_head; dbp->flag != EOLIST; dbp = dbp->next) {
	if (badblk(dbp->dfn)) 
		claimabs(new_head, dbp);
    }

    /* then go back and free dummy blocks */
    for (dbp = new_head; dbp->flag != EOLIST; dbp = dbp->next) {
	if (dbp->flag == ALLOCATED)
		dbp->flag = UNUSED; 
    }

    /* get new cylinder blocks from new list. */
    /* link each new block to end of its sfd->cp list */

    for (dbp = old_head; dbp->flag != EOLIST; dbp = dbp->next) {
	if (dbp->flag == USED) {
	    struct dskblk *cp=NULL, *ocp=NULL, *xcp=NULL, *allocsf();
	    struct sndesc *getnsfd();

	    if (badblk(dbp->dfn)) 
		continue;	/* already on new list */
	    /* get to end of the sfd's cp list, if any, last valid in ocp */
	    /* this step makes non-contiguous files work */
	    for (cp = dbp->dsksfd->cp; cp != NULL; ocp = cp, cp = cp->next)
		/* empty */ ;
	    /* add new link from new list */
	    xcp = allocsf(dbp->dsksfd, dbp->len, dbp->seq, new_head); 
	    if (xcp == NULL) {
		fprintf(stderr, "allocsf failed\n");
		exit(1);
	    }
	    /* allocsf makes new block point to dbp->dsksfd automatically */
	    /* if there was a list, make bi-directional link */
	    if (ocp != NULL) { 
		ocp->next = xcp; 
		xcp->last = ocp; 
	    }
	    else /* otherwise we are starting a new list for this sfd */
		dbp->dsksfd->cp = xcp;
	    xcp->next = NULL;				/* terminate list */
	}
    }

    /* print out the list */
ask:	if (!yes("\nDo you want to preview the list of moves?", 0)) {
	    if (ycnt++ < 1) {	/* sez no the first time */
		    printf("Are you sure?");
		    goto ask;
	    }
	    else {		/* sez no the second time */
		    printf("OK, welcome to life in the fast lane!\n");
	    }
	}
	else {
	    printf("%-30s %8s\t==> %8s\n", "name", "from", "to");
    	    for (dbp = old_head, nbp = new_head; dbp->flag != EOLIST; 
		    nbp = new_head, dbp = dbp->next) {
		if (dbp->flag != USED) 		/* ignore unused blocks */
		    continue;
		if ((nbp = match(dbp, new_head)) == NULL) {
			fprintf(stderr, "quiting.\n");
		}
		if (dbp->base == nbp->base)	/* ignore unmoved blocks */
		    continue;
		printf("%-30s %8d\t==> %8d\n", dbp->dfn, dbp->base, nbp->base);
	    }
	}

    if (!yes("\nShall we do it, then?", 0)) {
	printf("bie\n"); 
	exit(1); 
    }
    ofid = ifid = getrawdev(sfdevice, 2);	/* used by cylcp() */
    if (debug == 0) {
	printf("This part can take about 20 minutes for a 300MB pack\n");
	printf("\tso go get a cup of coffee.\n");
    }
    printf("%-30s %8s ==> %8s %8s %8s\n","name","from","to","cyls","secs");

    for 	(dbp = old_head, nbp = new_head; 
		dbp->flag != EOLIST; 
		nbp = new_head, dbp = dbp->next) {
	/* get new file to xfr in dbp, find its companion on nbp, and copy */
	if (dbp->flag != USED) 	/* skip unused blocks */
		continue;
	/* find new location on new_head to copy into */
	if ((nbp = match(dbp, new_head)) == NULL) {
		if (debug == 0)
			horriblerror(new_head);
	}
	if (dbp->base != nbp->base) {	/* mismatch indicates a block copy */
	    double time;

	    if (debug == 1) {
		time = CYLCPTIME * dbp->len;
		printf("%-30s %8d ==> %8d %8d   %6.3f\n", 
			dbp->dfn, dbp->base, nbp->base, dbp->len, time);
	    } else {
		time = CYLCPTIME * dbp->len;
		printf("%-30s %8d ==> %8d %8d   %6.3f ...", 
			dbp->dfn, dbp->base, nbp->base, dbp->len, time);
		(void) fflush(stdout);
		if (cylcp(ifid, ofid, dbp->base, nbp->base, dbp->len,
				bptrack, bpcyl)) {
			if (debug == 0)
			    horriblerror(new_head);
		}
		printf("done\n");
	    }
	}
	markall(new_head, dbp->dsksfd, SAVE);
	if (debug == 0) {
		/* write descriptor file */
		if (wsdf((FILE *) NULL, dbp->dsksfd) != 0) {
			fprintf(stderr, "burpsf: wsdf failed\n");
			exit(1);
		}
		/* write new free list - update every time for security */	
		if (wlist(new_head, alloc, 0) != 0) { 
			fprintf(stderr, "burpsf: wlist failed\n");
			exit(1);
		}
	}			
    }
    if (close(ifid) < 0)
	    perror("close");
    exit(0);
}

struct dskblk *
match(old, new)
	struct dskblk *old, *new;
{
	/* 
	 * while (names_not_equal or names_equal and not_same_sequence)
	 * 	setup next comparison;
	 */
	while ((strcmp(old->dfn, new->dfn)) || (old->seq != new->seq)) {
		if (new->flag == EOLIST) {
			fprintf(stderr, "match: no match for %s\n", old->dfn);
			return(NULL);
		}
		new = new->next;
	}
	return(new);
}

/* claimabs - grab an absolute cyl. sector */
/* assumes we are dealing with a fresh free list */

claimabs(head, dbp)
	struct dskblk *head, *dbp;
{
	extern struct dskblk *claim();
	register long nblks;

	/* find first block before one to be claimed */
	nblks = dbp->base - curbase(head);
	if (nblks > 0) {
	    if (claim(head, nblks) == NULL) {
		    fprintf(stderr, "burpsf: claim failed\n");
		    exit(1);
	    }
	}
	dbp->dsksfd->cp = allocsf(dbp->dsksfd, dbp->len, dbp->seq, head); 
	dbp->dsksfd->cp->next = NULL;		/* terminate list */
	markall(head, dbp->dsksfd, SAVE);	/* mark them used */
}



/*
 * sdfrdall - read all sdf files from free list.  This has no checking
 * mechanism like sdfck() in sfck does, and it is assumed that the free list
 * has been passed on and approved by sfck (not that that is such a bulletproof
 * filter...).  It returns a pointer to a linked list of sfd's.
 * It also sets the dsksfd field of each free list block to point to its
 * associated sdf.
 */

struct sndesc *
sdfrdall(listp, dskblkcnt)
    	struct dskblk *listp; 
	long *dskblkcnt;
{    
    extern struct sndesc *rsdf(); 
    extern char *strcat(), *strcpy();
    extern struct sfentry *findsf();
    int first = 0;
    struct sndesc *sfd, *curnode, *rootnode;
    FILE *fp;
    struct dskblk *dp;
    char sdfbuf[128], sndbuf[128];

    for (dp = listp; dp->flag != EOLIST; dp = dp->next) {
	*dskblkcnt++;		/* keep track */
	if (dp->flag == ALLOCATED || dp->flag == FREED) {
	    fprintf(stderr, "%s%s\n", 
		"Disk may not have any ALLOCED or FREED blocks ",
		"for bubbling to work.");
	    if (!debug) 
		return(NULL);
	}
	if (dp->flag == UNUSED)
	    dp->dsksfd = NULL;
	else {		/* it is USED, so get its sfd */
	    strcpy(sdfbuf, dp->dfn);
	    strcat(sdfbuf, SDFEXT);
	    strcpy(sndbuf, dp->dfn);
	    strcat(sndbuf, SNDEXT);
	    if (access(sdfbuf, 0)) {
		printf("sdf file is missing: %s, aborting\n", sdfbuf);
		if (!debug) return(NULL);
	    } else {
		fp = fopen(sdfbuf, "r");
		sfd = rsdf(fp, sdfbuf);
		if (fclose(fp) < 0) {
		    perror("fclose");
		    exit(1);
		}
		if (sfd == NULL) {
		    printf("%s%s%s\n", sdfbuf, " is damaged. ", "Aborting.");
		    return(NULL);
		}
		sfd->lkfile = sfs->lkdev;
		sfd->bufsiz = sfs->bsize;
		sfd->blksiz = sfs->bpblock;
	    }
	    /* make each disk block point to its sfd */
	    dp->dsksfd = sfd;
	    if (!first++)
		rootnode = curnode = sfd;	/* first time */
	    else {
		curnode->nxtsdf = sfd;		/* foreward link */
		sfd->lstsdf = curnode;		/* backward link */
		sfd->nxtsdf = NULL;		/* throw salt over sholder */
		curnode = sfd;			/* new current node */
	    }
	}
    }
    return(rootnode);
}

long curbase(head)
	struct dskblk *head;
{
	for ( ; head->flag != UNUSED; head = head->next) 
		/* empty */ ;
	return(head->base);
}

badblk(name)
	char *name;
{
    register char *c; 
    char *rindex();
    c = rindex(name, '/');
    if (!strncmp(c+1, BADBLOCKFILE, strlen(BADBLOCKFILE))) {
	if (debug) printf("badblock file: %s\n", name);
	return(-1);
    }
    return(0);
}

/*
 * horriblerror - try to save world in some semblance of order.
 * This routine will read down new_head, writing out the new disk list
 * up to the point it died in /snd/dskcyls.new, then the old list
 * in /snd/dskcyls.old.  
 * The usual case for comming here is that cylcp() hit an i/o error
 * of some sort.  In that case, it was somewhere in the middle of a copy
 * that was aborted.  Since we stop copying here, neither the sdf file
 * nor the original bits for the file have been destroyed.  The way to
 * proceed is to rebuild the free list with sfck.  
 */

horriblerror(new_head)
	struct dskblk *new_head;
{
    fprintf(stderr, "\nAaaaarrrrrgggh!!!!\n");
    if (wlist(new_head, newalloc, 0) != 0)
	    fprintf(stderr, "burpsf: wlist failed\n");
    exit(1);
}


/*
 * burpsf - squeeze the unused bubbles of freespace out of the disk.
 * This does a linear compaction.  It first coalesces adjacent free
 * blocks.  Then it goes from low addresses in the disk to hi, copying
 * files down to fill all the chinks.  It could be smarter, if it first
 * looked for files of the exact size to fill the holes instead of
 * moving all files down one after the other, but that strategy would
 * still not always succeed in filling all the holes.
 * 
 * This routine must always follow on a check of the integrety of the
 * disk free list via sfck(1x).  You MUST correct any errors that occur
 * there first, or risk loosing the ENTIRE DISK worth of files!!!
 * Hence, it is not unwise to have done a dump of the disk first, also.
 * 
 * The routine must first read in the entire free list, and read all the
 * sdf files into core at once.  This is because the non-realtime files
 * can be spread across the disk, and we'll be doing a linear compaction,
 * hence we may have to put one sfd down and pick it up again later as
 * we bubble the disk.
 * 
 * The actions:
 * * read the free list.
 * * zap the list for adjacent free blocks.
 * * read in all sdfs found there.  This is presumably all the files in the
 *   world.
 * * make a new free list in memory, initialized to all free.
 * * delete the old cp block lists attached to all sdf's.
 * * for each USED old_dskblk: 
 * *   allocsf() new_block off the new_list equal to size of old_dskblock.
 *  	this updates circular free list maintained by allocsf
 * *   link new_block to the end of old_block->dsksfd->cp list.
 * *   if base_addr of new_block != old_block, 
 * 	copy samples from old_block to new_block.
 * *   new_block->dsksfd = old_block->dsksfd;
 * * write out new_dskblk list as new free list in /snd/dskcyls.
 * * write out all sdf's.
 * * whew!
 */
E 1
