/*
 *	Dan Timis - UCSB -	Thu Aug  6 12:20:36 PDT 1987
 */

#include <stdio.h>
#include <carl/defaults.h>
#include <carl/carl.h>
#include <carl/procom.h>
#include <ctype.h>
#include <rpc/rpc.h>

/*
 * 'xdrout' reads from stdin a header followed by samples. 
 * The header is a 'procom' one.
 * The samples are floats or shorts and it is the header who tells
 * us what kind of samples we have.
 * 'xdrin' builds a similar header but in a xdr manner (xdr strings
 * and not NULL terminated ones) writes it to the 'stdout'. 
 * Then the samples are converted from their machine dependent 
 * representation to their external reprentation and written
 * to 'stdout'.
 * 'xdrout' could be used for converting data comming from a program
 * the produces a 'procom' header and samples and sending them to 
 * another machine.
 * Example:
 *
 *   program_producing_samples | xdrout | -> to_another_machine
 */
XDR	xdrs;

main()
{
	char	*c;
	short	s;
	float	f;

	/*
	 * Get the procom header from stdin
	 */
	if(getheader(stdin)==NULL){
		fprintf(stderr,"xdrout: error: no header\n");
		exit(-1);
	}
	/*
	 * Try to find if we have floats or shorts
	 */
	else if((c=getprop(stdin,H_FORMAT))==NULL){
		fprintf(stderr,
			"xdrout: error: no format in the header\n");
		exit(-1);
	}
	/*
	 * Writing an xdr header to stdout then
	 * converting the floats and writing them on stdout
	 */
	else if(!strcmp(c,H_FLOATSAM)){
		if(!putxdrheader())
			exit(-1);
		while(fgetfloat(&f,stdin)==sizeof(float))
			if(!xdr_float(&xdrs,&f))
				exit(-1);
	}
	/*
	 * Writing an xdr header to stdout then
	 * converting the shorts and writing them on stdout
	 */
	else if(!strcmp(c,H_SHORTSAM)){
		if(!putxdrheader())
			exit(-1);
		while(fgetshort(&s,stdin)==sizeof(short))
			if(!xdr_short(&xdrs,&s))
				exit(-1);
	}
	else {
		fprintf(stderr,
			"xdrout: error: incorrect format\n");
		exit(-1);
	}
	exit(0);

}


/*
 * putxdrheader() builds an xdr header.
 * For each pair 'propname' / 'propval' of the procom header associated
 * to stdin, writes two xdr strings on stdout.
 * Return 1 on success 0 on failure.
 */
putxdrheader()
{

	register PROP *p;
	register struct fltbuf *f;

	xdrstdio_create(&xdrs, stdout, XDR_ENCODE);

	f = &fb[fileno(stdin)];

	for (p = f->p; p != NULL; p = p->nextprop) {
		if (!xdr_string(&xdrs, &(p->propname), 1024))
			return(0);
		if (!xdr_string(&xdrs, &(p->propval), 1024))
			return(0);
	}	
	return(1);
}
