/*
Denis Lorrain, avril 1986.

Compile with ...

	CFLAGS = -DUNIXFILES -O
	transpsf:	transpsf.o

Change the #definition of MAXCHANS, if more channels are needed
*/

# include <stdio.h>
# include <math.h>
# include <sys/types.h>
# include <sys/stat.h>
# include <sys/file.h>
# include <sfheader.h>

# define FAUX {fprintf(stderr,"Usage: transpsf In-sound Out-sound < Function\n");\
		exit(1);}
# define HEADSIZE 1024
# define MAXCHANS 4
# define MAXSHORT 32767.0
# define COMPUTE (insamps[0][num]+((insamps[1][num]-insamps[0][num])*fract))
			
# define FLUSH	nbytesO = (outframe * nchans * sfclass(&hd)) % SF_BUFSIZE;\
		if(write(sfd2,outbuf,nbytesO) != nbytesO) {\
		fprintf(stderr,"Bad write to output file.\n");\
		close(sfd2);\
		close(sfd);\
		exit(1);\
		}
# define STOPERROR	close(sfd2);\
			close(sfd);\
			exit(1);

main(argc,argv)
int argc;
char *argv[];
{
	struct stat st;
	SFHEADER hd, hd2;
	char *buffer, *malloc(), *outbuf, newname[HEADSIZE];
	char *cp, *cp2, *getsfname();
	int sfd, error = 0, sfd2;
	int nchans, num, nbytesO, numO, nbytesI, numI, class, bytperfram;
	short *shortin, *shortout;
	long outframe = 0, outframe1, outframe2, totinframes;
	long	lowinframe = 0,
		highinframe = 1,
		oldlow = -2,
		oldhigh = -1;
	double step, step1, time1, step2, time2;
	double srate;
	double insamps[2][MAXCHANS];
	double slopestep, fract, inframe = 0.0;

/* Check parameters */
	if(argc != 3 ) FAUX;
	if(!strcmp(argv[1],argv[2])) FAUX;	

/* Open In-sound file */
	cp = getsfname(*++argv);
	if((sfd = open(cp,O_RDONLY)) == -1) {
		fprintf(stderr,"Can't find soundfile %s\n",cp);
		exit(1);	
	}		
	if(rheader(sfd,&hd)) {
		fprintf(stderr,"Bad header read for %s\n",cp);
		close(sfd);
		exit(1);
	}
	hd2 = hd;
	if(fstat(sfd,&st)) {
		fprintf(stderr,"Bad fstat() for %s\n",cp);
		close(sfd);
		exit(1);
	}
	nchans = sfchans(&hd);
	if(nchans > MAXCHANS) {
		nchans = MAXCHANS;
		fprintf(stderr,"More than %d channels in %s: change limit in source code.\n",nchans,cp);
		close(sfd);
		exit(1);
	}
	if(sfclass(&hd) != SF_SHORT) {
		fprintf(stderr,"In-sound (%s) must be packed in short samples.\n",cp);
		close(sfd);
		exit(1);
	}
	srate = sfsrate(&hd);
	class = sfclass(&hd);
	bytperfram = class * nchans;
	totinframes = (sfbsize(&st) / bytperfram) ;

/* Open Out-sound file */
	strcpy(newname,*(argv+1));
	if((sfd2 = open(getsfname(newname),O_CREAT|O_TRUNC|O_WRONLY,0644))<0) {	
	      fprintf(stderr,"Can't create soundfile %s\n",getsfname(newname));
		close(sfd);
		exit(1);
	}
	if(wheader(sfd2,&hd)) {/* copy header from source file onto new file */
		fprintf(stderr,"Failed to write new header.\n");
		STOPERROR
	}

/* Allocate buffers */
	if(((buffer = malloc(SF_BUFSIZE)) == NULL) || 
		((outbuf = malloc(SF_BUFSIZE)) == NULL)) {
		fprintf(stderr,"Bad call to malloc.\n");
		STOPERROR
	}
	shortin = (short *) buffer;
	shortout= (short *) outbuf;

/* Read first step-time pair */
	scanf("%lf %lf",&step1, &time1);
	if (time1 != 0.0) {
		fprintf(stderr,"First time point != 0\n");
		STOPERROR
	}
	outframe1 = time1 * srate;
	if (step1 <= 0) {
		fprintf(stderr,"First step <= 0\n");
		STOPERROR
	}
	step = step1;
		
/* (( 1 )) Read step-time pairs loop */
while (scanf("%lf %lf",&step2, &time2) != EOF){
	outframe2 = time2 * srate;
	if (outframe2 <= outframe1) {
		fprintf(stderr,"Non-increasing time points at %f sec. of Function\n",time2);
		FLUSH
		STOPERROR
	}
	if (step2 <= 0) {
		fprintf(stderr,"Step <= 0 at %f sec. of Function\n",time2);
		FLUSH
		STOPERROR
	}
	slopestep = (double) ((step2 - step1) / (outframe2 - outframe1));

/* (( 2 )) Read samples loop, inside a segments of step function */
	for(outframe=outframe1; outframe<outframe2; outframe++){
		fract = inframe - lowinframe;
		if(lowinframe != oldlow){
			oldlow = lowinframe;
			if(oldlow == oldhigh){
				for(num=0; num<nchans; num++)
					insamps[0][num] = insamps[1][num];
			}
			else{
		for(num=0; num<nchans; num++){
		nbytesI=((lowinframe * bytperfram)+(num * class)) % SF_BUFSIZE;
		if(nbytesI == 0)
			if(read(sfd,buffer,SF_BUFSIZE) <= 0) {
			fprintf(stderr,"Bad read from input file.\n");
			FLUSH
			STOPERROR
			}
		numI=nbytesI/2;
		insamps[0][num] = ((float) shortin[numI]) / MAXSHORT;
		}
			}
			oldhigh = highinframe;
			if (highinframe > totinframes) {
				for(num=0; num<nchans; num++){
					insamps[1][num] = 0.0 ;
				}
			}
		else{
		for(num=0; num<nchans; num++){
		nbytesI=((highinframe*bytperfram)+(num * class)) % SF_BUFSIZE;
		if(nbytesI == 0)
			if(read(sfd,buffer,SF_BUFSIZE) <= 0) {
			fprintf(stderr,"Bad read from input file.\n");
			FLUSH
			STOPERROR
			}
		numI=nbytesI/2;
		insamps[1][num] = ((float) shortin[numI]) / MAXSHORT;
		}
		}
				}
		for(num=0; num<nchans; num++){
		nbytesO=((outframe * bytperfram)+(num * class)) % SF_BUFSIZE;
		if((nbytesO == 0) && (outframe != 0))
			if(write(sfd2,outbuf,SF_BUFSIZE) != SF_BUFSIZE) {
			fprintf(stderr,"Bad write to output file.\n");
			close(sfd2);
			close(sfd);
			exit(1);
			}
		numO=nbytesO/2;
		shortout[numO] = (short)(floor((COMPUTE*MAXSHORT)+0.5));
		}
		step += slopestep;
		inframe += step;
		lowinframe = (long) floor(inframe);
		if (lowinframe > totinframes){
			FLUSH
			close(sfd2);
			close(sfd);
			fprintf(stderr,"End of In-sound.\n");
			exit(error);
		}
		highinframe = lowinframe+1;
	}
		
	outframe1 = outframe2;
	step1 =	step2;
	time1 = time2;
}

	FLUSH
	close(sfd2);
	close(sfd);
	fprintf(stderr,"End of step-time function.\n");
	exit(error);
}
