#include "sndawk.lx.h"
#include <stdio.h>

#define R	done++; return(1);

/*
 * SALLOC est la creation d'un nouvel symmbole. Ses freres et fils sont NULL.
 */
#define SALLOC ALLOC(symb,SYMB) symb->frereg = symb->frered = symb->fils = NULL;symb -> line = last -> line;

/*
 * STYPE affecte au symbole x le type y
 */
#define STYPE(x,y) x->symbtype = y;

/*
 * LIEN cree un lien "fraternel" entre deux symboles. Le frere droit de x est
 * desormais y et le frere gauche de y est x.
 */
#define LIEN(x,y) x->frered = y; y->frereg = x;

/*
 * FILS: x devient le fils de y. Il recoit d'abords comme fils l'arbre
 * (eventuellement vide) fils de y puis il devient le fils de y. 
 * Il perd ses freres.
 */
#define FILS(x,y) x->fils = y->fils; y->fils = x; x->frereg = x->frered = NULL;

%%
\# include "sndawk.h"
\# include <stdio.h>

extern SYMB *root;
extern int done;

reduce(first,last,i)
	SYMB	*first, *last;
	int	i;
{
	SYMB	*symb, *aux;

	switch(i){

@	SHARP	VPROG	SHARP
/*
 * VPROG devient VROOT et root pointe sur lui (# et # disparessent)
 */
			root = first->frered;
			STYPE(root,VROOT)
			root -> frereg = root -> frered = NULL;
			free(first);
			free(last);;
			R

@	VBEGIN	VCORPS	VEND
@	VBEGIN	VCORPS
@	VCORPS	VEND
@	VCORPS
/*
 * Un nouveau SYMB de valeur VPROG est cree. Il s'insert a la place de 
 * la liste de first a last et prend first comme fils
 */
			SALLOC
			STYPE(symb,VPROG)
			LIEN(first->frereg,symb)
			LIEN(symb,last->frered)
			first -> frereg = last -> frered = NULL;
			symb -> fils = first;
			R

@	LBEGIN	VSTAT
/*
 * VSTAT devient VBEGIN et LBEGIN disparait
 */
			STYPE(last,VBEGIN)
			LIEN(first->frereg,last)
			free(first);
			R
			
@	LEND	VSTAT
/*
 * VSTAT devient VEND et LEND disparait
 */
			STYPE(last,VEND)
			LIEN(first->frereg,last)
			free(first);
			R

@	VCORPS	VSTAT
/*
 * Le fils de VSTAT s'ajoute a la fin de la liste des fils de VCORPS.
 * VSTAT disparait.
 */
			LIEN(first,last -> frered)
			for(aux=first->fils;aux->frered!=NULL;aux=aux->frered);
			LIEN(aux,last->fils)
			free(last);
			R

@	VSTAT
/*
 * VSTAT devient VCORPS
 */
			STYPE(first,VCORPS)
			R

@	VSTAT3	LPTVIRG
/*
 * LPTVIRG disparait VSTAT3 devient VSTAT
 */
			STYPE(first,VSTAT)
			LIEN(first, last -> frered)
			free(last);
			R

@	VSTAT2
/*
 * VSTAT2 devient VSTAT ou VSTAT3
 */
			if(first -> frered -> symbtype == LPTVIRG)
				STYPE(first,VSTAT3)
			else	STYPE(first,VSTAT)
			R

@	LACCOUVR	VCORPS	LACCFERM
/*
 * VCORPS devient VSTAT ou VSTAT3. Les accolades disparaissent.
 */
			LIEN(first->frereg,first->frered)
			LIEN(last->frereg,last->frered)
			if(last -> frered -> symbtype == LPTVIRG)
				STYPE(first -> frered ,VSTAT3)
			else	STYPE(first -> frered ,VSTAT)
			free(first);
			free(last);
			R

@	LWHILE	VEXP
/*
 * VEXP devient VWHILE et LWHILE disparait.
 */
			STYPE(last,VWHILE)
			LIEN(first -> frereg, last)
			free(first);
			R
			
@	VWHILE	VSTAT
/*
 * Un nouveau VSTAT est cree. Il recoit comme fils le VWHILE. Le VSTAT a droite
 * de VWHILE devient le frered du fils de VWHILE (frere de la condition).
 */
			SALLOC
			STYPE(symb,VSTAT2)
			LIEN(first -> frereg, symb)
			LIEN(symb, last -> frered)
			symb -> fils = first;
			LIEN(first -> fils, last)
			first -> frereg = first -> frered = NULL;
			last -> frered = NULL;
			R
			
@	LIF	VEXP
/*
 * VEXP devient VIF et LIF disparait.
 */
			STYPE(last,VIF)
			LIEN(first -> frereg, last)
			free(first);
			R
			
@	VIF	VSTAT
/*
 * Un nouveau VSTAT2 est cree. Il recoit comme fils le VIF. Le VSTAT a droite
 * de VIF devient le frered du fils de VIF (frere de la condition).
 */
			if(last -> frered ->symbtype == LELSE){
				STYPE(last, VIFELSE)
				R
			}
			SALLOC
			STYPE(symb,VSTAT2)
			LIEN(first -> frereg, symb)
			LIEN(symb, last -> frered)
			symb -> fils = first;
			LIEN(first -> fils, last)
			first -> frereg = first -> frered = NULL;
			last -> frered = NULL;
			R
			
@	VIF	VIFELSE	LELSE	VSTAT
			STYPE(last -> frereg, VSTAT2)
			STYPE(first -> frered, VSTAT)
			LIEN(first -> frereg, last -> frereg)
			LIEN(last -> frereg, last -> frered)
			last -> frereg -> fils = first;
			LIEN(first -> fils, first -> frered)
			LIEN(first -> frered, last)
			first -> frereg = first -> frered = NULL;
			last -> frered = NULL;
			R
 
@	LPRINT	VEXP
/*
 * VEXP devient VSTAT. Il recoit comme fils le LPRINT (qui erite comme
 * fils l'ancien fils de VEXP)
 */
			STYPE(last,VSTAT2)
			LIEN(first -> frereg, last)
			FILS(first, last)
			R
			
@	LPRINTF	LSTRING VEXP
/*
 * VEXP devient VSTAT. LSTRING devient d'abord le fils de LPRINTF puis
 * il prend comme frere droit le fils de l'ancien VEXP, puis le tout
 * (LPRINTF avec comme liste de fils LSTRING et son nouveau frere )
 * devient le fils du nouveau VSTAT.
 */
			STYPE(last,VSTAT2)
			LIEN(first -> frereg, last)
			FILS(first -> frered, first)
			LIEN(first -> fils, last -> fils)
			last -> fils = first;
			first -> frereg = first -> frered = NULL;
			R

@	LVAR	LASGNOP	VEXP
@	LVAR	LASGNOP	VEXPALT
/*
 * VEXP ou VEXPALT change en VSTAT. LVAR recoit comme frere droit le fils
 * de l'ancien VEXP ou VEXPALT et devient provisoirement le fils de VSTAT.
 * LASGNOP devient le fils de VSTAT (en heritant comme fils la liste LVAR
 * fils de VEXP ou VEXPALT).
 */
			STYPE(last,VSTAT2)
			LIEN(first, last -> fils)
			last->fils = first;
			FILS(last -> frereg, last)
			LIEN(first -> frereg, last)
			first -> frereg = NULL;
			R

@	VEXP	LPTINTER	VALT
/*
 * VEXP devient VEXPALT. LPTINTER devient son fils en heritant comme fils
 * la liste fils de l'ancien VEXP fils de VALT. VALT disparait.
 */
			STYPE(first,VEXPALT)
			LIEN(first->fils,last->fils)
			LIEN(first,last->frered)
			FILS(last->frereg,first);
			free(last);
			R

@	VEXP	LDEUXPTS	VEXP
/*
 * Le premier VEXP devient VALT. Son fils recoit comme frere droit le
 * fils du deuxime VEXP. LDEUXPTS et VEXP disparaissent.
 */
			STYPE(first,VALT)
			LIEN(first->fils,last->fils)
			LIEN(first,last->frered)
			free(last->frereg);
			free(last);
			R
			
@	VRELEXP
/*
 * VRELEXP est remplace par VEXP
 */
			STYPE(first,VEXP)
			R

@	VARTEXP
/*
 * VARTEXP est remplace par VRELEXP
 */
			STYPE(first,VRELEXP)
			R

@	VTERM
/*
 * VTERM est remplace par VARTEXP
 */
			STYPE(first,VARTEXP)
			R

@	LARTOP1 VFACT
/*
 * Si LARTOP1 est "-" il devient LUNOP et s'insert entre VFACT et son fils.
 * S'il est "+" il disparait.
 */
			LIEN(first->frereg,last)
			if(first -> lexval.ival == MINUS) {
				STYPE(first,LUNOP)
				FILS(first,last)
			}
			else
				free(first);
			R

@	VFACT
/*
 * VFACT est remplace par VTERM
 */
			STYPE(first,VTERM)
			R

@	LVAR
@	LNUM
@	LISAMPS
@	LOSAMPS
/*
 * Un nouveau SYMB est cree de valeur VFACT. Des LIENs sont crees entre le
 * frere gauche de LNUM ou LVAR et VFACT et entre cului-ci et le frere
 * droit de LNUM ou LVAR qui devient le fils de VFACT.
 */
			SALLOC
			STYPE(symb,VFACT)
			LIEN(first->frereg,symb)
			LIEN(symb,last->frered)
			FILS(first,symb)
			R

@	LPAROUVR	VEXP	LPARFERM
/*
 * Des LIENs sont crees entre le frere gauche de la paranthese ouvrante et
 * VEXP et entre celui-ci et le frere droit de la paranthese fermante.
 * VEXP change en VFACT et les parantheses disparessent.
 */
			LIEN(first->frereg,first->frered)
			LIEN(last->frereg,last->frered)
			STYPE(last->frereg,VFACT)
			free(first);
			free(last);
			R

@	VEXP	LOGOP	VRELEXP
@	VRELEXP	LRELOP	VARTEXP
@	VARTEXP	LARTOP1	VTERM
@	VTERM	LARTOP2	VFACT
/*
 * Le sousarbre du dernier terme ou facteur devient le frere droit du
 * sousarbre du premier terme ou expression. L'operateur devient leur
 * nouveau pere et le fils du premier terme ou expression. Le deuxieme
 * terme ou facteur disparait.
 */
			LIEN(first->fils,last->fils)
			FILS(first->frered,first)
			LIEN(first,last->frered)
			free(last);
			R

		default:
			return(NULL);
	}
}
