#include "sndawk.h"
#include "gram.h"
#include "sndawk.lx.h"
#include <stdio.h>

extern	char	*pretty();

REGLE *root;				/* la racine des regles de derivation
					 */
PRECREL *Eq, *Fplus, *Lplus, *All;	/* Eq     l'origine des relations =.,
					 * Fplus	"	"	  F+,
					 * Lplus	"	"	  L+.
					 * All		"   de toutes les rel
					 */

main () {
    REGLE * regle, *last;
    int     i[5],
            j,
	    precno,count,
            error;
    PARTD * partd, *lastpd, *pd;
    PRECREL * precrel, *lastpl, *pl;


/*
 * On lit cinq entiers. Le premier est la variable, les quatre autres les
 * symboles de la partie droite d'une regle (0 pour le mot vide). On s'arrete
 * quand il n'y a plus rien a lire.
 */
    while (scanf ("%d%d%d%d%d", &i[0], &i[1], &i[2], &i[3], &i[4]) != EOF) {

	ALLOC (regle, REGLE)		/* on alloue l'espace pour une REGLE
					 */
	    if (root == NULL)		/* racine vide = premiere regle */
	    root = regle;
	else
	    last -> next = regle;	/* sinon on l'ajoute a la fin */
	last = regle;
	regle -> var = i[0];		/* c'est la variable */
	regle -> next = NULL;
	regle -> partd = NULL;

/*
 * On boucle au plus quatre fois mais on s'arrete quand on trouve 0 (mot vide)
 */
	for (lastpd = NULL, j = 1; i[j] > 0 && j <= 4; j++) {
	    ALLOC (partd, PARTD)	/* on alloue de l'espace pour chaque 
					 * PARTD */
		if (lastpd == NULL)	/* c'est le premier? */
		regle -> partd = partd; /* on le met en partd de la regle */
	    else
		lastpd -> next = partd; /* sinon on l'ajoute a la fin */
	    lastpd = partd;
	    partd -> symb = i[j];	/* c'est la valeur du symbole */
	    partd -> val = 0;
	    partd -> next = NULL;
	}
    }

/*
 * On imprime les regle pour le debugging et on signale si partie droite vide
 */
    for (regle = root; regle != NULL; regle = regle -> next) {
#ifdef	DEBUG
	printf ("%s\t->", pretty(regle -> var));
#endif
	if (regle -> partd == NULL) {
	    printf ("\nerror: NULL right member\n");
	    exit (-1);
	}
#ifdef	DEBUG
	for (partd = regle -> partd; partd != NULL; partd = partd -> next)
	    printf ("\t%s", pretty(partd -> symb));
	printf ("\n");
#endif
    }

/*
 * Pour chaque regle on parcourt la partie droite tant que le symbole a un
 * suivant. On ajoute a la liste des relations =. et a la liste de toutes les
 * relations, les deux symbole consecutives.
 */
    for (regle = root; regle != NULL; regle = regle -> next)
	for (partd = regle -> partd; partd -> next != NULL; partd = partd -> next) {
	    addprecrel (&Eq, partd -> symb, partd -> next -> symb, NULL);
	    addprecrel (&All, partd -> symb, partd -> next -> symb, EQUAL);
	}

/*
 * On imprime pour le debugging les relations trouvees
 */
#ifdef	DEBUG
    for (precrel = Eq; precrel != NULL; precrel = precrel -> next) {
	printf ("%s\t=.", pretty(precrel -> symb));
	for (partd = precrel -> partd; partd != NULL; partd = partd -> next)
	    printf ("\t%s", pretty(partd -> symb));
	printf ("\n");
    }
#endif

/*
 * Pour chaque regle on ajoute a la relation Fplus le premier symbole
 * de la partie droite. On obtient ainsi les relations F.
 */
    for (regle = root; regle != NULL; regle = regle -> next)
	addprecrel (&Fplus, regle -> var, regle -> partd -> symb, NULL);

/*
 * On imprime pour le debugging les relations trouvees
 */
#ifdef DEBUG
    for (precrel = Fplus; precrel != NULL; precrel = precrel -> next) {
	printf ("%s\tF", pretty(precrel -> symb));
	for (partd = precrel -> partd; partd != NULL; partd = partd -> next)
	    printf ("\t%s", pretty(partd -> symb));
	printf ("\n");
    }
#endif

/*
 * Pour chaque regle on parcourt la partie droite jusqu'a la fin. On
 * obtient ainsi les relation L et on les ajoute a Lplus.
 */
    for (regle = root; regle != NULL; regle = regle -> next) {
	for (partd = regle -> partd; partd -> next != NULL; partd = partd -> next);
	addprecrel (&Lplus, partd -> symb, regle -> var, NULL);
    }

/*
 * On imprime pour le debugging les relations trouvees
 */
#ifdef DEBUG
    for (precrel = Lplus; precrel != NULL; precrel = precrel -> next) {
	printf ("%s\tL", pretty(precrel -> symb));
	for (partd = precrel -> partd; partd != NULL; partd = partd -> next)
	    printf ("\t%s", pretty(partd -> symb));
	printf ("\n");
    }
#endif


/*
 * On a dans Fplus seulement les F. On parcourt la liste et pour chaque element
 * (a gauche de F) on parcourt la partd (liste de symboles a droite de F). Pour
 * chaque, on reparcourt la liste Fplus en le cherchant en partie gauche de F
 * (il ne peut etre qu'une seule fois). On ajoute les symboles de la liste partd
 * ainsi trouve a la liste partd de depart seulement s'il n'existe pas encore.
 * Ainsi en continuant de parcourir la partd de la liste de depart on peut
 * rencontrer des nouveau symboles qui n'etait pas la au debut et on va les
 * prendre en consideration etant sur qu'on va s'arreter vu l'unicite des 
 * symbole dans la liste Fplus et dans chaque partd.
 */
    for (precrel = Fplus; precrel != NULL; precrel = precrel -> next)
	for (partd = precrel -> partd; partd != NULL; partd = partd -> next) {
	    for (lastpl = Fplus; lastpl != NULL; lastpl = lastpl -> next)
		if (lastpl -> symb == partd -> symb)
		    break;
	    if (lastpl != NULL)
		for (lastpd = lastpl -> partd; lastpd != NULL;
			lastpd = lastpd -> next)
		    addprecrel (&Fplus, precrel -> symb,
			    lastpd -> symb, NULL);

	}

/*
 * On imprime pour le debugging les relations trouvees
 */
#ifdef DEBUG
    for (precrel = Fplus; precrel != NULL; precrel = precrel -> next) {
	printf ("%s\tF+", pretty(precrel -> symb));
	for (partd = precrel -> partd; partd != NULL; partd = partd -> next)
	    printf ("\t%s", pretty(partd -> symb));
	printf ("\n");
    }
#endif


/*
 * Exactement la meme chose que pour Fplus maintenent pour Lplus.
 */
    for (precrel = Lplus; precrel != NULL; precrel = precrel -> next)
	for (partd = precrel -> partd; partd != NULL; partd = partd -> next) {
	    for (lastpl = Lplus; lastpl != NULL; lastpl = lastpl -> next)
		if (lastpl -> symb == partd -> symb)
		    break;
	    if (lastpl != NULL)
		for (lastpd = lastpl -> partd; lastpd != NULL;
			lastpd = lastpd -> next)
		    addprecrel (&Lplus, precrel -> symb,
			    lastpd -> symb, NULL);

	}


/*
 * On imprime pour le debugging les relations trouvees
 */
#ifdef DEBUG
    for (precrel = Lplus; precrel != NULL; precrel = precrel -> next) {
	printf ("%s\tL+", pretty(precrel -> symb));
	for (partd = precrel -> partd; partd != NULL; partd = partd -> next)
	    printf ("\t%s", pretty(partd -> symb));
	printf ("\n");
    }
#endif


/*
 * On cherche les relations =. et pour chacune on cherche dans Fplus le symbole
 * a droite de =. S'il existe on parcourt sa liste partd et on ajoute la 
 * relation <. a la liste All. La relation etant la conposition de =. et F+.
 */
    for (precrel = Eq; precrel != NULL; precrel = precrel -> next)
	for (partd = precrel -> partd; partd != NULL; partd = partd -> next) {
	    for (lastpl = Fplus; lastpl != NULL; lastpl = lastpl -> next)
		if (lastpl -> symb == partd -> symb)
		    break;
	    if (lastpl != NULL)
		for (lastpd = lastpl -> partd; lastpd != NULL;
			lastpd = lastpd -> next) {

#ifdef BUG
		    printf ("%s\t<.\t%s\n", pretty(precrel -> symb),
			    pretty(lastpd -> symb));
#endif
		    addprecrel (&All, precrel -> symb,
			    lastpd -> symb, LESS);
		}

	}


/*
 * On fait la meme chose pour Lplus et Eq. On obtient la composition de
 * L+ et =. on l'ajoute a ALL comme >. mais on cherche le symbole a droite
 * de =. aussi dans la liste des F+ et si on le trouve on ajoute tous les
 * symboles de sa partd a ALL comme >. Ainsi L+ =. et L+ =. F+ donne L+ =. F*
 */
    for (precrel = Lplus; precrel != NULL; precrel = precrel -> next)
	for (partd = precrel -> partd; partd != NULL; partd = partd -> next) {
	    for (lastpl = Eq; lastpl != NULL; lastpl = lastpl -> next)
		if (lastpl -> symb == partd -> symb)
		    break;
	    if (lastpl != NULL)
		for (lastpd = lastpl -> partd; lastpd != NULL;
			lastpd = lastpd -> next) {
/*
 * Le symbole doit etre terminal pour ajouter >. a All
 */
		    if (lastpd -> symb > MAXVAR) {
#ifdef BUG
			printf ("%s\t>.\t%s\n", pretty(precrel -> symb),
				pretty(lastpd -> symb));
#endif
			addprecrel (&All, precrel -> symb,
				lastpd -> symb, GREATER);
		    }
		    for (pl = Fplus; pl != NULL; pl = pl -> next)
			if (pl -> symb == lastpd -> symb)
			    break;
		    if (pl != NULL)
			for (pd = pl -> partd; pd != NULL; pd = pd -> next)
			    if (pd -> symb > MAXVAR) {
#ifdef BUG
				printf ("%s\t>.\t%s\n", pretty(precrel -> symb),
					pretty(pd -> symb));
#endif
				addprecrel (&All, precrel -> symb,
					pd -> symb, GREATER);
			    }
		}

	}

/*
 * On a toutes les relations dans All on va construire le programme precedence.c
 */
#ifndef DEBUG
    bprint (0);
    precno = 1;
#endif

    for (precrel = All; precrel != NULL; precrel = precrel -> next)
	for (partd = precrel -> partd; partd != NULL; partd = partd -> next) {
	    if (partd -> val > GREATER) {
		fprintf (stderr,
			"error: bad precedence relation\n");
#ifdef DEBUG
	    	fprintf (stderr,"%s\t%s\t%s\n", pretty(precrel -> symb),
		    pretty(partd -> val * 128 * 128), pretty(partd -> symb));
#endif
		error++;
	    }
#ifdef DEBUG
	    printf ("%s\t%s\t%s\n", pretty(precrel -> symb),
		    pretty(partd -> val * 128 * 128), pretty(partd -> symb));
#else
/*
 * Le programme precedence.c doit retourner la valeur de la relation
 * entre deux symbole. L'appel sera "rel = precedence ( x );" ou x et un
 * entier qui contient la valeur du premier symbole decale a gauche de 
 * sept bits plus la valeur du deuxieme symbole. precedence() retourne un
 * entier. Les trois derniers bits de faible poids de celui-ci indiquent
 * si chaque relation existe ou pas. On construit donc un programme avec
 * des lignes de la formes:   case (symb1 *128 + symb2):  return(rel);
 */
	    if (count++ == 480){
		eprint(precno);
		bprint(precno++);
		count = 0;
	    }
		    printf ("\t\tcase\t(%d)\t:\treturn(%d);\n",
		    precrel -> symb * 128 + partd -> symb, partd -> val);
#endif
	}
#ifndef DEBUG
    eprint (0);
#endif
    exit (error);
}



/*
 * Cette fonction ajoute a la liste pointe par *Pl le symbole i s'il
 * n'existe pas encore et a sa partd le symbole j s'il n'existe pas
 * encore. La valeur val (relation de precedence)  est ajoute par un
 * ou logique.
 */
addprecrel (Pl, i, j, val)
PRECREL ** Pl;			/* Pl est un pointeur vers un pointeur de
				 * PERCREL parce que on peut changer ainsi
				 * la valeur du pointeur vers PRECREL 
				 */
SYMBOL i, j;
int     val;
{
    PRECREL * precrel, *lastpl;
    PARTD * partd, *lastpd;


/*
 * Si *Pl (pointeur pointe par Pl) est NULL c'est qu'on ajoute une premiere
 * relation et on alloue alors l'espace neccesaire.
 */
    if (*Pl == NULL) {
	ALLOC (*Pl, PRECREL)
	    (**Pl).symb = i;
	(**Pl).next = NULL;
	(**Pl).partd = NULL;
    }

/*
 * On parcourt la liste pointe par le pointeur pointe par Pl en cherchant le i
 */
    for (precrel = *Pl; precrel != NULL; precrel = precrel -> next) {
	if (precrel -> symb == i)
	    break;
	lastpl = precrel;
    }

/*
 * Si precrel est NULL c'est qu'on est arriver a la fin de la liste sans le
 * trouver (si on vient de le mettre pour la premiere fois en tete, precrel
 * n'est pas NULL). On alloue alors de l'espace et on le met en fin de liste.
 */
    if (precrel == NULL) {
	ALLOC (precrel, PRECREL)
	    precrel -> symb = i;
	precrel -> next = NULL;
	precrel -> partd = NULL;
	lastpl -> next = precrel;
    }
/*
 * Bien sur on poura faire un peut plus rapide en evitant de parcourir les deux
 * dernieres etapes si on a fait la premiere, mais comme c'est une seul fois...
 */



/*
 * On fait la meme chose (en trois etapes) pour la partie droite et le SYMB j
 */
    if (precrel -> partd == NULL) {
	ALLOC (precrel -> partd, PARTD)
	    precrel -> partd -> next = NULL;
	precrel -> partd -> symb = j;
	precrel -> partd -> val = val;
    }

    for (partd = precrel -> partd; partd != NULL; partd = partd -> next) {
	if (partd -> symb == j)
	    break;
	lastpd = partd;
    }

    if (partd == NULL) {
	ALLOC (partd, PARTD)
	    partd -> symb = j;
	partd -> next = NULL;
	partd -> val = val;
	lastpd -> next = partd;
    }
    else
/*
 * val ne peut avoir que les valeurs 1, 2 ou 4. En faisant un ou logique
 * les trois bit de faibles pois de partd -> val vont indique la presence
 * ou l'absence d'une relation.
 */
	partd -> val = partd -> val | val;
}


/*
 * Cette fonction imprime les premiers lignes de precedence.c
 */
bprint (i)
	int	i;
{
    if (i == 0)	printf ("%s%s%s%s%s%s%s",

	    "# include <stdio.h>\n\n",
	    "extern\tint\terror;\n",
	    "precedence",
	    "(i)\n",
	    "	int i;\n",
	    "{\n",
	    "	switch(i){\n\n");

    else	printf ("%s%d%s%s%s%s",

	    "precedence",
	    i,
	    "(i)\n",
	    "	int i;\n",
	    "{\n",
	    "	switch(i){\n\n");

}


/*
 * Cette fonction imprime les derniers lignes de precedence.c
 */
eprint (i)
	int 	i;
{
    if (i==0)	printf ("%s%s%s%s",

	    "		default		:	error++;\n",
	    "					return(NULL);\n",
	    "	}\n",
	    "}\n");

    else	printf ("%s%d%s%s%s",

	    "		default		:	return(precedence",
	    i,
	    "(i));\n",
	    "	}\n",
	    "}\n");
}
