#include "sndawk.h"
#include "sndawk.lx.h"
#include <stdio.h>

extern	SYMB 	*root, *yylex ();
extern	VAR	*cherchevar ();
extern	SVAR	*cherchesvar ();
IOSAMPS	*isamps, *osamps;
int	c_isprint = 0;
FILE	*popen();

analyse_lexicale () {
    int     i,
            j,
            n;
    SYMB	*symb, *first, *last;
    char	*string;
    FIL		*f;


/* On alloe de l'espace pour isamps et osamps */

	ALLOC(isamps,IOSAMPS)
	ALLOC(osamps,IOSAMPS)
/*
 * On alloue de l'espace pour un premier symbole qui est #
 */
    last = symb = ALLOC (root, SYMB)
    symb -> fils = symb -> frereg = symb -> frered = NULL;
    symb -> line = 0;
    symb -> symbtype = SHARP;


/*
 * yylex retourne un pointeur vers le prochain lexeme. On l'ajoute a la liste.
 */
    while (symb = yylex ()) {
	last -> frered = symb;
	symb -> frereg = last;
	symb -> fils = symb -> frered = NULL;

	switch(symb -> symbtype) {

/*
 * Si le lexeme est une variable on cherche a avoir sa structure associe 
 * si on l'a rencontre deja ou une nouvelle structere si c'est la premiere
 * fois qu'on la rencontre.
 */
	case LVAR:
		symb -> lexval.address = cherchevar(symb -> lexval.string);
		break;

/*
 * Si le lexeme est une svariable on cherche a avoir sa structure associe 
 */
	case LSVAR:
		symb -> lexval.saddress = cherchesvar(symb -> lexval.string);
		break;

/*
 * Si c'est $ on prend la structure qui garde la valeur de l'echantillon courant
 */
	case LISAMPS:
		symb -> lexval.ioaddress = isamps;
		break;

	case LOSAMPS:
		symb -> lexval.ioaddress = osamps;
		break;

	case LCROOUVR:
		if (last -> symbtype == LVAR){
			last -> lexval.address -> valeur =
			    (float *)realloc(last -> lexval.address -> valeur,
				1024 * sizeof(float));
		}
		break;

	case LSTRING:
		if(last -> symbtype == LRELOP){
			if(last -> lexval.ival == GT){
				last -> symbtype = LWRITE;
				symb -> symbtype = LFILE;
				ALLOC(f,FIL)
				if((f->stream = fopen(symb->lexval.string,"w"))
							==NULL){
					fprintf(stderr,"open failed on %s\n",
						symb -> lexval.string);
					exit(-1);
				}
				f -> name = symb -> lexval.string;
				symb -> lexval.file = f;
			}
			else if(last -> lexval.ival == LT){
				last -> symbtype = LREAD;
				symb -> symbtype = LFILE;
				ALLOC(f,FIL)
				if((f->stream = fopen(symb->lexval.string,"r"))
							==NULL){
					fprintf(stderr,"open failed on %s\n",
						symb -> lexval.string);
					exit(-1);
				}
				f -> name = symb -> lexval.string;
				symb -> lexval.file = f;
			}
		}
		else if(last -> symbtype == LAPPEND){
			symb -> symbtype = LFILE;
			ALLOC(f,FIL)
			if((f -> stream = fopen(symb->lexval.string,"a"))
						==NULL){
				fprintf(stderr,"open failed on %s\n",
					symb -> lexval.string);
				exit(-1);
			}
			f -> name = symb -> lexval.string;
			symb -> lexval.file = f;
		}
		else if(last -> symbtype == LPIPE) {
			symb -> symbtype = LCOM;
			ALLOC(f,FIL)
			if((f -> stream = popen(symb->lexval.string,"w"))
						==NULL){
				fprintf(stderr,"can't find command %s\n",
					symb -> lexval.string);
				exit(-1);
			}
			f -> name = symb -> lexval.string;
			symb -> lexval.file = f;
		}
		break;

	case LARTOP1:
		switch(last -> symbtype) {

			case	LSVAR:
			case	LVAR:
			case	LISAMPS:
			case	LOSAMPS:
			case	LPARFERM:
			case	LINCDEC:
			case	LPOSTOP:
			case	LNUM:
			case	LCROFERM:
				if (last -> line == symb -> line) break;
			default:
				symb -> symbtype = LUNOP;
		}
		break;

	case LPRINT:
	case LPRINTF:
		c_isprint++;
		break;
	}

	switch (last -> symbtype) {
		case	LIF:
		case	LWHILE:
		case	LFUNC:
			if (symb -> symbtype != LPAROUVR) {
				fprintf(stderr,"syntax error in line %d\n",
					symb -> line);
				exit(-1);
			}
			break;
		case	LSTRING:
			if  (((symb -> symbtype == LPTVIRG || 
				    symb -> symbtype == LACCFERM ||
				    symb -> line != last -> line) &&
				(last -> frereg -> symbtype == LPRINTF ||
				    last -> frereg -> symbtype == LPRINTERR))||
			    (((symb -> symbtype == LRELOP &&
						symb -> lexval.ival == GT) ||
				    symb -> symbtype == LAPPEND) && 
				last -> frereg -> symbtype == LPRINTF))
					last -> symbtype = LSTRING2;
			else if(symb -> symbtype == LPIPE){
				if (last -> frereg -> symbtype == LPRINTF)
					last -> symbtype = LSTRING2;
				else{
					last -> symbtype = LCOM;
					ALLOC(f,FIL)
					if((f -> stream = 
					 	popen(last->lexval.string,"r"))
							==NULL){
						fprintf(stderr,
						    "can't find command %s\n",
						    last -> lexval.string);
						exit(-1);
					}
					f -> name = last -> lexval.string;
					last -> lexval.file = f;
				}
			}
			break;
	}


	last = symb;
    }


/*
 * On ajoute a la fin un nouveau #
 */
    if (last -> symbtype == LSTRING) last -> symbtype = LSTRING2;
    ALLOC (symb, SYMB)
    last -> frered = symb;
    symb -> frereg = last;
    symb -> symbtype = SHARP;
    symb -> line = symb -> frereg -> line + 1;
    symb -> fils = symb -> frered = NULL;

#ifdef DEBUG
    prettyprint (root, 0);
#endif
}
