# include <stdio.h>

# include <sys/types.h>
# include <sys/stat.h>
# include <sys/file.h>
# include <sfheader.h>

# define SKIP error++; goto skip

/* This program is designed to reverse existing soundfiles.
   The channels of the soundfile are kept in the original order
   contrary to what an analog tape would do. */

main(argc,argv)
int argc;
char *argv[];
{
	int sfd1,sfd2;
	register int i;
	off_t bytes;
	int readbyte,error = 0;
	SFHEADER hd;
	char *forward,*back,*malloc();
	struct stat st;
	int backsu,units,nsu,nextsu;
	char *name, *getsfname(),  newname[1024];

	/* Get memory for buffers */

	if(argc < 2)
		usage(1);
	forward = malloc(SF_BUFSIZE);
	back = malloc(SF_BUFSIZE);
	if(!forward || ! back) {
		fprintf(stderr,"Bad allocation for buffers\n");
		exit(1);
	}

	while(--argc) { /* Soundfile numbers from command line */
		name = getsfname(*++argv);
		if((sfd1 = open(name,O_RDONLY)) == -1) {
			fprintf(stderr,"Can't open soundfile %s\n",name);
			SKIP;
		}

		if(fstat(sfd1,&st) == -1) {
			fprintf(stderr,"Can't fstat %s\n",name);
			close(sfd1);
			SKIP;
		}

		if(rheader(sfd1,&hd)) {
			fprintf(stderr,"Read header for %s failed\n",name);
			close(sfd1);
			SKIP;
		}

skip:		if((*(argv+1) != NULL) && (!strcmp("-f",*(argv+1)))) {
			argc -= 2;
			argv += 2;
			if(argc)
				strcpy(newname,getsfname(*argv));
			else
				argc++;
		}
		else if((*(argv+1) != NULL) && (!strncmp("-f",*(argv+1),2))) {
			argc -= 1;
			argv += 1;
			strcpy(newname,getsfname((*argv)+2));
		}
		else {
			strncpy(newname,name,1024-1);
			strcat(newname,".r");
		}
		if(error) {
			error = 0;
			continue;
		}

		if(!newname)
			continue;

		if((sfd2 = open(newname,O_CREAT|O_TRUNC|O_WRONLY,0644)) < 0) {
			fprintf(stderr,"Can't create %s\n",newname);
			close(sfd1);
			continue;
		}

		if(wheader(sfd2,&hd)) { /* Duplicate header */
			fprintf(stderr,"Write to header failed.\n");
			close(sfd1);
			close(sfd2);
			continue;
		}

		bytes = sfbsize(&st);
		readbyte = bytes % SF_BUFSIZE;
		if(sflseek(sfd1,(long) -readbyte,2) == -1) {
			fprintf(stderr,"Bad seek\n");
			exit(1);
		}

		while(bytes > 0) { /* For all of the samples */
			if((readbyte = read(sfd1,forward,SF_BUFSIZE)) < 0) {
				fprintf(stderr,"Bad read on soundfile %s\n",name);
				exit(1);
			}
			/* units = samples per read.
				     nsu = number of sample units per read. 
					(sample unit = all channels
				   	 for this sample slot).
				     nextsu = next sample unit.
				     backsu = current backward sample unit 
						starting channel.	*/

			units = readbyte / sfclass(&hd);
			nextsu = 0;
			nsu = units - sfchans(&hd);
			if(sfclass(&hd) == SF_FLOAT) { /* Do floating point file */
				register float *fbuf = (float *) back;
				float *fforward = (float *) forward;

				while((char *) fbuf < back + readbyte) {
					backsu = nsu - nextsu;
					for(i = 0; i < sfchans(&hd); i++) 
						*fbuf++ = *(fforward + backsu + i);
					nextsu += i;
				}
			}
			else { /* Integer (short) file */
				register short *sbuf = (short *) back;
				short *sforward = (short *) forward;

				while((char *) sbuf < back + readbyte) {
					backsu = nsu - nextsu;
					for(i = 0; i < sfchans(&hd); i++) 
						*sbuf++ = *(sforward + backsu + i);
					nextsu += i;
				}
			}

			if(write(sfd2,back,readbyte) != readbyte) {
				fprintf(stderr,"Bad write on soundfile\n");
				exit(1);
			}
			if((bytes -= readbyte) > 0) 
			 if(sflseek(sfd1,(long) -(SF_BUFSIZE + readbyte),1) == -1) {
			 		fprintf(stderr,"Bad seek\n");
					exit(1);
				}
		}
		close(sfd1);
		close(sfd2);
	}
}
usage(i)
	int i;
{
	fprintf(stderr,"%s",
		"\nusage: retrosf filename [-f outfilename] ...\n");
	exit(i);
}
