#ifndef lint
static char *sccs_xid = "%W%	%G%	IRCAM";
#endif

/*
 * Who is on a certian device?
 */

#include <pwd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/vnode.h>
#include <ufs/inode.h>
#include <nlist.h>

char	*fcore	= "/dev/kmem";
char	*fnlist	= "/vmunix";
int	fc;

struct nlist nl[] = {
#define	SINODE	0
	{ "_inode" },
#define	SNINODE	1
	{ "_ninode" },
	{ "" }
};


devbusy(dev)
{
	register struct inode *ip;
	struct inode *xinode, *ainode;
	register int nin;
	int ninode, gotone = 0;


	if ((fc = open(fcore, 0)) < 0) {
		printf("Can't find %s\n", fcore);
		return(1);
	}

	nlist(fnlist, nl);
	if (nl[0].n_type == 0) {
		printf("no namelist\n");
		return(1);
	}

	nin = 0;
	ninode = getw(nl[SNINODE].n_value);
	xinode = (struct inode *)calloc(ninode, sizeof (struct inode));
	lseek(fc, (int)(ainode = (struct inode *)getw(nl[SINODE].n_value)), 0);
	read(fc, xinode, ninode * sizeof(struct inode));
	for (ip = xinode; ip < &xinode[ninode]; ip++)
		if (ip->i_count)
			nin++;
	for (ip = xinode; ip < &xinode[ninode]; ip++) {
		if (ip->i_count == 0)
			continue;
		if(dev == ip->i_dev) {
			if(!gotone) {
				printf("These people OWN an open inode.\n");
				printf("If root owns one then it is the /snd2 directory itself\n");
			}
			printf("\t%s\n", getpwuid(ip->i_uid)->pw_name);
			gotone++;
		}
	}
	free(xinode);
	return(gotone);
}

getw(loc)
	off_t loc;
{
	int word;

	lseek(fc, loc, 0);
	read(fc, &word, sizeof (word));
	return (word);
}
