static char *sccs_wid = "@(#)checkfs.c	1.4	5/15/88	IRCAM";
#include <stdio.h>
#include <ctype.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/vnode.h>
#include <ufs/fs.h>
#include <ufs/inode.h>
#include <sys/dir.h>
#include <sys/stat.h>
#include <fstab.h>

#define	MAXNINDIR	(MAXBSIZE / sizeof (daddr_t))
#define	MAXINOPB	(MAXBSIZE / sizeof (struct dinode))
#define	SPERB		(MAXBSIZE / sizeof(short))

struct bufarea {
	struct bufarea	*b_next;		/* must be first */
	daddr_t	b_bno;
	int	b_size;
	union {
		char	b_buf[MAXBSIZE];	/* buffer space */
		short	b_lnks[SPERB];		/* link counts */
		daddr_t	b_indir[MAXNINDIR];	/* indirect block */
		struct	fs b_fs;		/* super block */
		struct	cg b_cg;		/* cylinder group */
		struct dinode b_dinode[MAXINOPB]; /* inode block */
	} b_un;
	char	b_dirty;
};

typedef struct bufarea BUFAREA;

BUFAREA	sblk;			/* file system superblock */

#define	sblock		sblk.b_un.b_fs
#define	cgrp		cgblk.b_un.b_cg



checkfs(dev)
	char *dev;
{
	struct stat statb;
	int super = SBLOCK;
	int i, j, size;
	int c, d, cgd,fd;
	char *calloc();

	if (stat("/", &statb) < 0) {
		printf("Can't stat root\n");
		return(0);
	}

	if (stat(dev, &statb) < 0) {
		printf("Can't stat %s\n", dev);
		return (0);
	}

	if ((statb.st_mode & S_IFMT) == S_IFBLK)
		;
	else {
		printf("file is not a block device\n");
		return (0);
	}
	if ((fd = open(dev, 0)) < 0) {
		printf("Can't open %s\n", dev);
		return (0);
	}

	/*
	 * Read in the super block and its summary info.
	 */
	if (bread(fd, &sblock, super, SBSIZE) == 0)
		return (0);

	sblk.b_bno = super;
	sblk.b_size = SBSIZE;
	/*
	 * run a few consistency checks of the super block
	 */
	if (sblock.fs_magic != FS_MAGIC)
		{ printf("MAGIC NUMBER WRONG\n"); return (0); }
	if (sblock.fs_ncg < 1)
		{ printf("NCG OUT OF RANGE\n"); return (0); }
	if (sblock.fs_cpg < 1 || sblock.fs_cpg > MAXCPG)
		{ printf("CPG OUT OF RANGE\n"); return (0); }
	if (sblock.fs_nsect < 1)
		{ printf("NSECT < 1\n"); return (0); }
	if (sblock.fs_ntrak < 1)
		{ printf("NTRAK < 1\n"); return (0); }
	if (sblock.fs_spc != sblock.fs_nsect * sblock.fs_ntrak)
		{ printf("SPC DOES NOT JIVE w/NTRAK*NSECT\n"); return (0); }
	if (sblock.fs_ipg % INOPB(&sblock))
		{ printf("INODES NOT MULTIPLE OF A BLOCK\n"); return (0); }
	if (cgdmin(&sblock, 0) >= sblock.fs_cpg * sblock.fs_spc / NSPF(&sblock))
		{ printf("IMPLIES MORE INODE THAN DATA BLOCKS\n"); return (0); }
	if (sblock.fs_ncg * sblock.fs_cpg < sblock.fs_ncyl ||
	    (sblock.fs_ncg - 1) * sblock.fs_cpg >= sblock.fs_ncyl)
		{ printf("NCYL DOES NOT JIVE WITH NCG*CPG\n"); return (0); }
	if (sblock.fs_fpg != sblock.fs_cpg * sblock.fs_spc / NSPF(&sblock))
	if (sblock.fs_size * NSPF(&sblock) <=
	    (sblock.fs_ncyl - 1) * sblock.fs_spc)
		{ printf("SIZE PREPOSTEROUSLY SMALL\n"); return (0); }
	if (sblock.fs_size * NSPF(&sblock) > sblock.fs_ncyl * sblock.fs_spc)
		{ printf("SIZE PREPOSTEROUSLY LARGE\n"); return (0); }
	/* rest we COULD repair... */
	if (sblock.fs_cgsize != fragroundup(&sblock,
	    sizeof(struct cg) + howmany(sblock.fs_fpg, NBBY)))
		{ printf("CGSIZE INCORRECT\n"); return (0); }
	if (sblock.fs_cssize !=
	    fragroundup(&sblock, sblock.fs_ncg * sizeof(struct csum)))
		{ printf("CSSIZE INCORRECT\n"); return (0); }
	/* OK now check if it is an IRCAM soundfile system. */
	if (sblock.fs_bsize != sblock.fs_fsize)
		{ printf("Not an IRCAM soundfile system (Block != frag)\n"); return (0); }
	if (sblock.fs_bsize != (16*1024))
		{ printf("Not an IRCAM soundfile system (Not 16K blocks)\n"); return (0); }
	close(fd);
	return (1);
}
bread(fd, buf, blk, size)
	daddr_t blk;
	int fd;
	register size;
	char *buf;
{
	if (lseek(fd, blk * DEV_BSIZE, 0) < 0)
		printf("SEEK %d\n", blk);
	else if (read(fd, buf, size) == size)
		return (1);
	printf("READ %d\n", blk);
	return (0);
}
