# include "mixer.h"
# include <stdio.h>
# include <sys/stat.h>

# define ALIGN(s,y) while((s) % (y)) (s)++
# define ROUND(s) ((s) + .5)
# define ISSEC(x) if(((x) & TIME_IN_SAMP) == 0)  
# define OFRAMEIT(x) (x).l = ((x).s * outchans)
# define IFRAMEIT(x) (x).l = ((x).s * ptr->chans)

sec2unit()
{

	/* Procedure to convert from seconds to samples  */

	register struct  SOUND_FILE *ptr;
	struct  stat statst;
#ifndef UNIXFILES
	struct  SFDESC sfdesc;
	short   *cylptr; 
#else
	SFHEADER header;
#endif
	int     sfd;
	struct envptr *doenv();

	for(ptr = queue; ptr; ptr = ptr->right_activate) {

		/* Open each descriptor file */

		if((sfd = sfopen(ptr->fname,READ)) == -1) {
			errs.str = ptr->fname;
			errs.errnum = NOFILE;
			mixerr();
		}

		if(sffstat(sfd,&sfdesc,&statst,&cylptr)) {
			errs.str = ptr->fname;
			errs.errnum = NOFILE;
			mixerr();
		}


#ifdef UNIXFILES
		if(rheader(sfd,&header)) {
			errs.str = ptr->fname;
			errs.errnum = BADHEADER; 
			mixerr();
		}
#endif

		/* Get needed info from file */
		ptr->chans = SFCHANS;
		ptr->class = SFCLASS;
		sfclose(sfd);

		if(ptr == queue) /* Set output rate from first input channel */
			srate = SFSRATE;


		ISSEC(ptr->start.flags)
			ptr->start.sft.l = (long)(ROUND(ptr->start.sft.s 
				* srate * outchans)); 
		else
			OFRAMEIT(ptr->start.sft);
		ALIGN(ptr->start.sft.l,outchans);

		ISSEC(ptr->end.flags)
			ptr->end.sft.l = ptr->start.sft.l + (long) 
				(ROUND(ptr->end.sft.s * srate * (float) outchans)); 
		else {
			OFRAMEIT(ptr->end.sft);
			ptr->end.sft.l += ptr->start.sft.l;
		}
		if(ptr->end.sft.l == 0)
			ptr->end.sft.l = SFBSIZE / (long) (SFCLASS * SFCHANS); 
		ALIGN(ptr->end.sft.l,outchans);

		ISSEC(ptr->offset.flags)
			ptr->offset.sft.l = (long) (ROUND(ptr->offset.sft.s 
				* SFCHANS * srate)); 
		else
			IFRAMEIT(ptr->offset.sft);
		ALIGN(ptr->offset.sft.l,ptr->chans);

#ifdef UNIXFILES
		ptr->loc = ptr->offset.sft.l * SFCLASS;
#endif


		if(ptr->more && ptr->more->h_envptr) { /* envelope */
			ptr->more->c_envptr = ptr->more->h_envptr =  
				doenv(ptr->more->h_envptr,ptr->start.sft.l,
					ptr->end.sft.l);
	        }
	}
}

/* Return pointer to sorted envelope */

struct envptr *doenv(hptr,starttime,eoftime)
	struct envptr *hptr;
	long eoftime, starttime;
{
	register struct envptr *ptr, *sptr = NULL, *smallone, *lastone;
	long youngest;

	for(ptr = hptr; ptr; ptr = ptr->env_next) { /* all envelope parts */

		if(ptr->env_start.sft.s == END_OF_FILE) /* EOF flag */
			ptr->env_start.sft.l = eoftime;
		else {
			ISSEC(ptr->env_start.flags)
				ptr->env_start.sft.l = (long)(ROUND(ptr->env_start.sft.s 
					* srate * outchans)); 
			else
				OFRAMEIT(ptr->env_start.sft);
			ALIGN(ptr->env_start.sft.l,outchans);
			if(ptr->env_start.sft.l < 0)  /* Offset from end */
				ptr->env_start.sft.l += eoftime; 
			else
				ptr->env_start.sft.l += starttime;
		}

	}
	/* linear search many times */
	while( hptr ) { /* Until no more on unsorted list */
	   for(youngest = -1, smallone = NULL,ptr = hptr; ptr; ptr = ptr->env_next) { /* look for smallest */
		if(youngest == -1 || ptr->env_start.sft.l <= youngest) { /* We found its slot */
			smallone = ptr;
			youngest = ptr->env_start.sft.l;
		}
	   }
	/* Remove node */
	if(smallone->env_pre) 
		smallone->env_pre->env_next = smallone->env_next;
	else /* Was head */
		hptr = hptr->env_next;
		
	if(smallone->env_next)
		smallone->env_next->env_pre = smallone->env_pre;
		

	 /* Enter node on sorted list at end or begining (first time) */
	 if(sptr) {
		smallone->env_pre =  lastone;
		lastone->env_next = smallone;
		lastone = smallone;
	 }
	 else  { /* head node */
	   	sptr = lastone = smallone;
		sptr->env_pre = sptr->env_next = NULL;
	 }
	}  
	for(ptr = sptr; ptr; ptr = ptr->env_next) { /* fill in the rest */
		if(ptr->env_next) {
			ptr->env_end = ptr->env_next->env_start.sft.l;
			ptr->env_diff = ptr->env_next->env_val - ptr->env_val;
		}
		else
			ptr->env_end = eoftime;

		ptr->env_dur =  ptr->env_end - ptr->env_start.sft.l;
		/* env_diff now is stored as a linear increment. */
		if(ptr->env_dur)
			ptr->env_diff /= (float) ptr->env_dur;
		
	}
	return(sptr);
}
