#include <stdio.h>
#include "mixer.h"
#include <math.h>

isoverflow(cur_unit)
long cur_unit;
{

	/* Check for overflow in the output 32 bit (float) buffer */
	double fabs();        /* Long abs */
	register counter;     /* Sample counter */
	double maxamp = 0.0;  /* Biggest overflowed sample within block */
	double abssamp;       /* Absolute value of sample */
	short overcounter = 0;/* Number of overflow within this block */

	for(counter = 0; counter < MIXUNIT; counter++) { /* For all of buf */
		abssamp = fabs((double) *(outflt + counter));
		if(abssamp > MAX16) { /* Overflow */
			overcounter++;
			if(abssamp > maxamp) maxamp = abssamp; /* Largest overflow */
		}
	}

	if(overcounter) { /* Was there overflow? */
		errs.errnum = OVERFLOW;
		errs.arg.f = (float) cur_unit / (float) srate / (float) outchans;
		mixerr();      /* Put out warning with time */
		printf("Samples out of range in block = %d, maxamp = %f\n",
		overcounter,maxamp);
		return(1);
	}
	return(0);
}


