# include <stdio.h>
# include "mixer.h"

static char SccsId[] = "%W%	%G%	IRCAM";

/* Main body of the digital sound file mixer by R. Gross */
/* globals */

struct SOUND_FILE *queue,*dealloc_queue,*last,*endptr;
char outfile[1024];
int outfd;
struct mixerrs errs;
short full;
short mixer_flags = (Q_MODE); /* Default to Quick and precise mode */
float srate = 16000.;
int outchans = 1;
int MIXUNIT = DMIXUNIT;
struct sftime gskip,gdur;
struct sftime cgskip,cgdur;
short gdurplus, cgdurplus;
short foutput;     
short mixnumber;

#ifdef UNIXFILES
short openfiles;     
#endif

/*  buffers pointers */
short   *inint,*outint;
float   *inflt,*outflt;

main(argc,argv)

int argc;
char *argv[];
{
	char *s;        /* Option pointer */
	double atof();
	int done = 0;
	close(15);
	close(16);
	close(17);
	close(18);
	close(19);
	if(argc != 1) {
		while(--argc > 0 && (*++argv)[0] == '-') 
			for(s = argv[0]+1; *s; s++)
				switch(*s)  {
				case 'c':       
					mixer_flags |= CHECK;   /* Just check syntax */
					break;
				case 'p':       
					mixer_flags |= PRINT;   /* print file of queue */
					break;
				case 'l':       
					mixer_flags |= CKAMP;   /* Do 32 bit math   
												   and check overflow */
					break;
				case 's':       
					cgskip.sft.s = (float) atof(*++argv);
					argc--;
					break;
				case 'd':       
					if(**++argv == '+') {
						cgdurplus = 1;
						cgdur.sft.s = (float) atof(*argv+1);
					}
					else
						cgdur.sft.s = (float) atof(*argv);
					argc--;
					break;
				case 'f':	
					foutput++;              
					break;
				case 'S':	/* Run silent */
					freopen("/dev/null","w",stderr);
					break;
				default:        
					errs.errnum = NOOPTION; 
					errs.str = s;
					mixerr();
				}

		if(argc == 1) /* Reopen stdin */
			if(freopen(*argv,"r",stdin) == NULL) {
				errs.errnum = NOFILE;
				errs.str = *argv;
				mixerr();
			}
	}

	/* This should not be needed but it seems  the suns reset
	   stderr to buffered mode when it is not a terminal. This change
	   is mostly for mixd */

	setlinebuf(stderr);
	/* Loop until EOF for input file */
	do {

	/* All specifications are on the standard input. Use procedure
		setup to return a pointer to the head of the sequential run queue. */

		if((done = setup()) < 0)
			exit(0);

	/* The start and end times must be set to the number of samples
		so that the mixer procedures can keep track of them.  */

		sec2unit();

	/* If the options for global skip or dur is used then adjust the run
		   queue */

		if(gskip.sft.s || gdur.sft.s) adjustq();

	/* Now create the run queue of ascending stop times for the soundfiles. 
	   An action time os either when a file start mixing into the output file
	   or when a file must be taken off of the queue. */

		dsetup();

	/* Now we have two queues: One for start times and one for stop times */
	/* Check out the file specifications before starting to mix */

		check();

	/* If the print option was used then print out the run queue */

		if(mixer_flags & PRINT) 
			qprint();

	/* If the Check flag was set then don't mix */

		if(!(mixer_flags & CHECK)) 
			mixctl(); 
		mixnumber++;
		if(!done)
			fprintf(stderr,"Ready\n");
	} while(!done);
	exit(0);
}


