# include <stdio.h>
# define ALIGN(s,y) while((s) % (y)) (s)++
# define ROUND(s) ((s) +.5) 
# define ABS(s) ((s) < 0 ? -(s) : (s))
# define ISSEC(x) if((x.flags & TIME_IN_SAMP) == 0)  
# define FRAMEIT(x) (x).l = ((x).s * outchans)

# include "mixer.h"

/* Alter the queue to reflect the global skip and duration times */

adjustq()
{

	register struct SOUND_FILE *ptr;
	struct SOUND_FILE *temp;
	short got = 0;

	/* If the gskip value is < 0 then leave the start times as is
	   let silence come in front of the queue. This should allow 
	   fade ins and fade outs to work if we catch them in the middle */

	ISSEC(gskip)
		gskip.sft.l = (long) ROUND(gskip.sft.s * (float) srate) * (float) outchans; 
	else
		FRAMEIT(gskip.sft);

	ISSEC(gdur)
		gdur.sft.l = (long) ROUND(gdur.sft.s * (float) srate) * (float) outchans; 
	else
		FRAMEIT(gdur.sft);

	ALIGN(gskip.sft.l,outchans);
	ALIGN(gdur.sft.l,outchans);

	ptr = queue;

	if(gdur.sft.l && ptr->start.sft.l > gskip.sft.l + gdur.sft.l) {
		errs.errnum = GSKIP;
		mixerr();
	}

	while(ptr)  {
		if(ptr->end.sft.l > gskip.sft.l) {     /* First file in bounds */
			queue = ptr; /* New head */
			queue->left_activate == NULL; /* Grounded pointer */
			got++;
			break;
		}
		else { /* Get rid of front files */
			queue = ptr->right_activate;
			free((char *) ptr);
			ptr = queue;
		}
	}

	if(!got) {      /* No file in bounds */
		errs.errnum = GSKIP;
		mixerr();
	}


	for(ptr = queue; ptr; ptr = ptr->right_activate) {
		if(ptr->end.sft.l <= gskip.sft.l) { /* delete file */
			ptr->left_activate->right_activate = ptr->right_activate; 
			ptr->right_activate->left_activate = ptr->left_activate;
			if(ptr->more) free(ptr->more);
			temp = ptr;
			ptr = ptr->left_activate; /* Backup one */
			free((char *) temp); 
			continue;
		}

		if(!full) {
			ptr->start.sft.l -= gskip.sft.l;
			ptr->end.sft.l -= gskip.sft.l;
			if(ptr->start.sft.l < 0) { /* start time */
				ptr->offset.sft.l += -ptr->start.sft.l;
				ptr->start.sft.l = 0;
			}
		}
		else { 
			if(ptr->start.sft.l < gskip.sft.l) {
				ptr->offset.sft.l += 
					((gskip.sft.l - ptr->start.sft.l) 
						/ outchans * ptr->chans);
				ptr->start.sft.l = gskip.sft.l;
			}
		}
	}
}
