h43895
s 00010/00002/00033
d D 1.7 86/07/03 17:22:08 yocom 7 6
c yocom edition: reports greatest overflow location
e
s 00000/00000/00035
d D 1.6 85/08/27 21:39:14 robert 6 5
c Version with input for samples.
e
s 00001/00001/00034
d D 1.5 85/06/25 20:28:51 robert 5 4
c Formatted for better printing. Works with sfname() for SFPATH.
e
s 00000/00000/00035
d D 1.4 85/06/25 12:02:48 robert 4 3
c 4.2 working version for UNIX files.
e
s 00000/00000/00035
d D 1.3 84/05/16 15:09:16 robert 3 2
c Working (I think) version for exact mixing.
e
s 00001/00001/00034
d D 1.2 84/05/11 16:54:07 robert 2 1
c First version of exact sample mixing. Robert
e
s 00035/00000/00000
d D 1.1 82/12/08 08:37:48 robert 1 0
c date and time created 82/12/08 08:37:48 by robert
e
u
U
t
T
I 1
#include <stdio.h>
#include "mixer.h"
#include <math.h>

isoverflow(cur_unit)
long cur_unit;
{

	/* Check for overflow in the output 32 bit (float) buffer */
	double fabs();        /* Long abs */
	register counter;     /* Sample counter */
	double maxamp = 0.0;  /* Biggest overflowed sample within block */
	double abssamp;       /* Absolute value of sample */
	short overcounter = 0;/* Number of overflow within this block */
I 7
	long maxsamploc;
E 7

	for(counter = 0; counter < MIXUNIT; counter++) { /* For all of buf */
		abssamp = fabs((double) *(outflt + counter));
		if(abssamp > MAX16) { /* Overflow */
			overcounter++;
D 5
			if(abssamp > maxamp) maxamp = abssamp;        /* Largest overflow */
E 5
I 5
D 7
			if(abssamp > maxamp) maxamp = abssamp; /* Largest overflow */
E 7
I 7
			if(abssamp > maxamp) {
			maxamp = abssamp; /* Largest overflow */
			maxsamploc = cur_unit + (long)counter;
			}
E 7
E 5
		}
	}

	if(overcounter) { /* Was there overflow? */
		errs.errnum = OVERFLOW;
D 2
		errs.arg.f = (float) (cur_unit * (long) MIXUNIT) / (float) srate / (float) outchans;
E 2
I 2
D 7
		errs.arg.f = (float) cur_unit / (float) srate / (float) outchans;
E 7
I 7
		errs.arg.f = (float)maxsamploc/(float)srate/(float)outchans;
		errs.arg.l = maxsamploc;
E 7
E 2
		mixerr();      /* Put out warning with time */
		printf("Samples out of range in block = %d, maxamp = %f\n",
		overcounter,maxamp);
I 7
		printf("maxsamploc = %ld time: %f\n",
			maxsamploc,
			(float)maxsamploc/(float)srate/(float)outchans);
E 7
		return(1);
	}
	return(0);
}


E 1
