h27458
s 00002/00000/00139
d D 1.15 86/07/04 18:08:25 robert 15 14
c forgot sccs keywords
e
s 00002/00001/00137
d D 1.14 86/07/03 17:16:30 yocom 14 13
c yocom edition: Overflow message gives both time and sample number
e
s 00001/00001/00137
d D 1.13 85/12/06 23:16:39 robert 13 12
c Output sampling rate is now set from the first member of the run queue.
e
s 00003/00003/00135
d D 1.12 85/10/22 14:30:33 robert 12 11
c Diags for envelope mistakes.
e
s 00004/00000/00134
d D 1.11 85/08/29 13:14:54 robert 11 10
c Added trap for input specs used before input file setup.
e
s 00000/00000/00134
d D 1.10 85/08/27 21:38:42 robert 10 9
c Version with input for samples.
e
s 00004/00000/00130
d D 1.9 85/08/27 16:29:00 robert 9 8
c Added error for negative fadein or fade out.
e
s 00004/00000/00126
d D 1.8 85/08/02 18:54:49 robert 8 7
c Added a few perror()s.
e
s 00003/00003/00123
d D 1.7 85/07/29 19:51:52 robert 7 6
c Added line numbers to more things.
e
s 00004/00000/00122
d D 1.6 85/07/25 09:59:53 robert 6 5
c Added alignment of to output and input sample frame sizes.
e
s 00015/00015/00107
d D 1.5 85/06/25 20:28:26 robert 5 4
c Formatted for better printing. Works with sfname() for SFPATH.
e
s 00006/00000/00116
d D 1.4 85/06/25 12:02:27 robert 4 3
c 4.2 working version for UNIX files.
e
s 00003/00000/00113
d D 1.3 84/05/16 15:08:54 robert 3 2
c Working (I think) version for exact mixing.
e
s 00000/00000/00113
d D 1.2 84/05/11 16:53:48 robert 2 1
c First version of exact sample mixing. Robert
e
s 00113/00000/00000
d D 1.1 82/12/08 08:37:44 robert 1 0
c date and time created 82/12/08 08:37:44 by robert
e
u
U
t
T
I 1
# include <stdio.h>
# include "mixer.h"

I 15
static char *sccs_id =   "%W%	%G%";

E 15
/* Procedure to reprot errors from the mixer program. Errors < NOPRINT are
   all fatal. */

mixerr()
{
	char *err = "ERROR!", *war = "WARNING";
	fprintf(stderr,"MIX: %s ",(errs.errnum < NOPRINT ? err : war));

	switch(errs.errnum) { 

	case NOFILE:   
		fprintf(stderr,"Sorry I can't access file %s\n",errs.str);
		break;
	case KEYWORD:  
D 7
		fprintf(stderr,"%s is not on my list of keywords.\n",
D 5
		errs.str);
E 5
I 5
			errs.str);
E 7
I 7
		fprintf(stderr,"(line %d) %s is not on my list of keywords.\n",
			errs.arg.i,errs.str);
E 7
E 5
		break;
	case NOFDS:    
I 8
		perror("NOFDS");
E 8
		fprintf(stderr,"Wow! I ran out of file descriptors. File = %s\n",
D 5
		errs.str);
E 5
I 5
			errs.str);
E 5
		unsavesfs();
		break;
	case NOOPTION: 
		fprintf(stderr,"I don't know the option [%s]\n",errs.str);
		break;
	case AMPFAC:   
		fprintf(stderr,"File %s has the absurd ampfac of %f\n",
D 5
		errs.str,errs.arg.f);
E 5
I 5
			errs.str,errs.arg.f);
E 5
		break;
	case EMPTYFILE:
		fprintf(stderr,"Ha! File %s has a duration less than zero\n",
D 5
		errs.str);
E 5
I 5
			errs.str);
E 5
		break;
	case SHORTFILE:
		fprintf(stderr,"File %s is not long enough.\n\tIts duration is %f\n",
D 5
		errs.str,errs.arg.f);
E 5
I 5
			errs.str,errs.arg.f);
E 5
		break;
	case BADCHAN:  
D 5
		fprintf(stderr,"Output file has been set to %d channels.\nOnly 1,2, or 4 allowed.\n",
		outchans); 
E 5
I 5
		fprintf(stderr,"Output file has been set to %d channels.\n",outchans); 
		fprintf(stderr,"Only 1,2, or 4 allowed.\n");
E 5
		break;
	case NOOUTPUT: 
D 7
		fprintf(stderr,"Output file can't be created. Sorry\n");
E 7
I 7
		fprintf(stderr,"Output file [%s] can't be created. Sorry\n",outfile);
E 7
		break;
	case NOMEM:    
I 8
		perror("NOMEM");
E 8
		fprintf(stderr,"Not enough memory available\n");
		break;

	case NOPRINT:  
		fprintf(stderr,"Output for the print option failed\n");
		break;
	case NOINPUT:  
		fprintf(stderr,"Not enough arguments on line %d\n",errs.arg.i);
		break;
	case ILLCHN:   
		fprintf(stderr,"Illegal channel specified for file %s, line number = %d\n",
D 5
		errs.str,errs.arg.i);
E 5
I 5
			errs.str,errs.arg.i);
E 5
		break;
D 13
	case SRATE:    
E 13
I 13
	case BADSRATE:    
E 13
D 5
		fprintf(stderr,"The sampling rate for file %s is %f.\n\tThe output file is %f!\n",
		errs.str,errs.arg.f,srate);
E 5
I 5
		fprintf(stderr,
			"The sampling rate for file %s is %f.\n\tThe output file is %f!\n",
			errs.str,errs.arg.f,srate);
E 5
		break;
	case MIXEDMODE:
D 5
		fprintf(stderr,"File %s has %d channels, output file is %d channels, no send was given\n",
		errs.str,errs.arg.i,outchans);
E 5
I 5
		fprintf(stderr,"File %s has %d channels, output file is %d ", 
			errs.str,errs.arg.i,outchans);
		fprintf(stderr,"channels, no send was given\n");
E 5
		break;
D 12
	case FADELONG: 
		fprintf(stderr,"Fade in plus fade out for file %s exceeds the duration.\n",
D 5
		errs.str);
E 5
I 5
			errs.str);
E 12
I 12
	case BADENV: 
		fprintf(stderr,"Envelope (file %s) has dup breakpoints at time %f\n",
			errs.str,errs.arg.f);
E 12
E 5
		break;
	case OVERFLOW: 
D 14
		fprintf(stderr,"Overflow at time %f\n",errs.arg.f);
E 14
I 14
		fprintf(stderr,"Greatest overflow at time %f,sample %ld\n",
				errs.arg.f, errs.arg.l);
E 14
		break;
	case GSKIP:    
		fprintf(stderr,"No files in range for partial mix\n");
		break;
	case SFSAVE:   
		fprintf(stderr,"Trouble %s file %s\n",errs.arg.c,errs.str);
		break;
	case SFTYPE:   
		fprintf(stderr,"File is not correct type (INT, FLOAT, SAMPLES).\n");
I 4
		break;
E 4
	case SFREAD:   
I 8
		perror("SFREAD");
E 8
		fprintf(stderr,"Bad read on file %s\n",errs.str);
		unsavesfs();
		break;
	case SFWRITE:  
I 8
		perror("SFWRITE");
E 8
		fprintf(stderr,"Bad write to output file\n");
		unsavesfs();
		break;
	case SKIP:     
		fprintf(stderr,"Bad skip on file %s\n",errs.str);
		unsavesfs();
		break;  
	case SFCLS:    
		fprintf(stderr,"Bad sfclose on file %s\n",errs.str);
		unsavesfs();
		break;
I 3
	case ILLUNIT:    
		fprintf(stderr,"Illegal mixunit specified = %d\n",errs.arg.i);
		break;
I 4
#ifdef UNIXFILES
	case BADHEADER:    
		fprintf(stderr,"Trouble with header for file = %s\n",errs.str);
		break;
#endif
I 9
	case SFFADE:    
		fprintf(stderr,"Fin or fout < 0 (line number %d)\n",
			errs.arg.i);
		break;
E 9
I 6
	case SFALIGN:    
		fprintf(stderr,"Read not aligned (file %s read = %d)\n",
			errs.str,errs.arg.i);
		break;
I 11
	case NOTSETUP:    
		fprintf(stderr,"No current input file - line %d ignored.\n",
			errs.arg.i);
		break;
E 11
E 6
E 4
E 3
	default:	
		fprintf(stderr,"Bad error number [%d]\n",errs.errnum);
		exit(1);
		break;
	}

	if(errs.errnum < NOPRINT) {    /* Fatal error? */
		fprintf(stderr,"Damn. Gotta stop mixin.\n");
		exit(1);
	}
}
D 5
/* End of mixerr.c */

E 5
E 1
