#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <disklock.h>


extern locklevel, verbose;
#define DISK 1
#define NOTDISK 0

struct dl {
	char	*cooked;
	char 	*raw;
	short	level; /* If not fd device this is level */
	short	type;  /* Is it a disk */
} disks[] = {  
	{ "/dev/hp4e", "/dev/rhp4e" ,1, DISK},
	{ "/dev/hp4f", "/dev/rhp4f" ,1, DISK},
	{ "/dev/hp5f", "/dev/rhp5f",1, DISK},
	{ "/dev/fps0", NULL ,0, NOTDISK},
	{ NULL,NULL,0, NOTDISK }
};

lockdevs(mode,fd)
{
	register struct dl *d = disks;
	struct stat st;
	struct stat filest;

	if(fstat(fd,&filest)) {
		perror("stat for lock");
		return(-1);
	}
		
	while(d->cooked) {
		if(stat(d->cooked,&st)) {
			perror(d->cooked);
			d++;
			continue;
		}
		/* Lock this device entry plus others that
		   are equal or lowel lock levels */

		if(d->level <= locklevel || filest.st_dev == st.st_rdev) {
			if(disklock(mode,st.st_rdev,st.st_mode))
				if(verbose)
					printf("Can't ");
			if(verbose)
				printf("%s %s\n",(mode == DISKLOCK_LOCK ? "lock" :
					"unlock"),d->cooked);
			if(d->raw) {
				if(stat(d->raw,&st)) {
					d++;
					continue;
				}
				if(disklock(mode,st.st_rdev,st.st_mode))
					if(verbose)
						printf("Can't ");
				if(verbose)
					printf("%s %s\n",(mode == DISKLOCK_LOCK ? "lock" :
						"unlock"),d->raw);
			}
			/* Skip if same physical unit */
			if(d->type == DISK && !strncmp(d->cooked,(d+1)->cooked,
					strlen(d->cooked)-1)) 
				d++; 
		}
		d++;
	}
}
