/* %W%	%G%	IRCAM (from 1.1	(CARL)	7/25/84	) */

# include <stdio.h>
# include <sys/types.h>
# include <carl/libsf.h>
# include <dsc.h>
# include <dsreg.h>
# include <sfheader.h>
# include <signal.h>


#define DSCDMA0 0
#define DSCDSK0 0

/* from play.c */
extern int verbose,sync, syncval;

/* how many buffers */
# define UBSIZE		4

extern char *valloc();

#ifdef TACKY
extern SFHEADER header;
#endif

char *waiter = "/dev/ttyh0";
int syncpid;

short *dsbuf;

char *dserrs[] = {
	"missing arguments/parameters",
	"converters in use",
	"buffer size wasn't modulo bsize",
	"buffer size was too small",
	"disk error",
	"converter error",
	"dsreset clobbered us",
	"sync timeout "
};

dsadc(sfd, adcfid, stbyte,  nsamps, srate, filts, repeat, seq, brdmon, blksize) 
	int sfd;
	int adcfid;
	long stbyte,  nsamps; 
	int srate; 
	long filts, repeat;
	short *seq;
	int brdmon,blksize; /* blksize = filesystem size */
{
	extern char *malloc();
	extern char *index();
	struct ds_seq dsseq;
	struct ds_err dserr;
	struct ds_fs dsf;
	register int erno;

	if (verbose)
		{
		printf("DSBYTYE=%D DSCOUNT=%D ",
			stbyte,  nsamps * BP16BIT);
		printf("DSRATE=%O rep=%D ", 
			srate, repeat);
		printf("filts=");
		switch (filts) {
		    case DS20KHZ:	printf("%d", ASC_HZ20>>1);	break;
		    case DS10KHZ:	printf("%d", ASC_HZ10>>1);	break;
		    case DSBYPAS:	printf("%d", ASC_BYPASS>>1); 	break;
		    case DS5KHZ:	printf("%d", ASC_HZ05>>1);
		    }
		printf("\n");
		}


	if ((dsbuf = (short *) valloc(blksize * UBSIZE)) == NULL) {
		perror("valloc");
		return(1);
	}

	if (setdsseq(adcfid, seq, DSCDMA0) < 0)	/* set up sequence ram */
		{
		fprintf(stderr, "converter sequence garbled\n");
		return(-1);
		}

	dsseq.dirt = srate;
	if (ioctl(adcfid, DSRATE, &dsseq) == -1) 
		{ perror("dsrate"); return(-1); }


	/* add filter params */
	if (ioctl(adcfid, filts, (struct ds_fs *) NULL) == -1) 
	    { perror("filts"); return(-1); }

	while (repeat--)
		{
		/* amount of file to convert */
		dsf.bnosiz = nsamps * BP16BIT;	/* bytes to transfer */
		if (ioctl(adcfid, DSCOUNT, &dsf) == -1) 
			{ perror("dsount"); return(-1); }


#ifdef TACKY
	/*      need to alter driver to understand skip for record
		but for now this hack will do. 
		Since we don't want to write over the header the first buffer
		full we will preload the buffer from here with the header.
		The dacs will skip over it but the I/O to disk will transfer
		the entire block to disk. */

		bcopy((char *) &header,(char *) dsbuf, sizeof(SFHEADER));
#endif
		/* byte offset in first block */
		sflseek(sfd,stbyte,0); 

		dsf.bnosiz = nsamps * BP16BIT;	/* bytes to transfer */
		if (ioctl(adcfid, DSCOUNT, &dsf) == -1) 
			{ perror("dscount"); return(-1); }

		dsf.bnosiz = sfd;	
		if (ioctl(adcfid, DS42BSD, &dsf) == -1) 
			{ perror("4.2 setting"); return(-1); }

		/* set broadcast or monitor mode */
		if (brdmon != 0) {
			if (ioctl(adcfid, brdmon, &dsf) == -1)
			{ perror("brdmon"); return(-1); }
		}

#ifdef SYNC
		if (sync) {
			if (ioctl(adcfid, DSSYNC, NULL) == -1) {
				perror("dssync"); 
				close(adcfid); 
				return (-1); 
			}
			if(!syncval)
				syncval = 30;
			dsf.bnosiz = syncval;
			if (ioctl(adcfid, DSSYNCTIMEVAL, &dsf) == -1) {
				perror("dssynctimeval"); 
				close(adcfid); 
				return (-1); 
			} 
			/* Spawn a proccess that triggers the wait. */
			syncpid = waitfor(waiter);

			fprintf(stderr,"sync [pid %d] waiting (%d second timeout) . .",
				syncpid,syncval);
		}
		else
#endif SYNC
			if(verbose) 
				fprintf(stderr, "reading...");

		if (read(adcfid, (char *) dsbuf, nsamps * BP16BIT) == -1) 
			{ 
			perror("read");
			if (ioctl(adcfid, DSERRS, &dserr) == -1) 
				{ perror("dserrs"); return(-1); }
			switch (dserr.errors) 
				{
				case EDS_ARGS : erno = 0; break;
				case EDS_ACC : erno = 1; break;
				case EDS_MOD : erno = 2; break;
				case EDS_SIZE : erno = 3; break;
				case EDS_DISK : erno = 4; break;
				case EDS_CERR : erno = 5; break;
				case EDS_RST : erno = 6; break;
#ifdef SYNC
				case EDS_TIMEOUT : 
					erno = 7;
					kill(syncpid,SIGTERM);
					break;
#endif
				}
			fprintf(stderr, "%s dmacsr=%o, asccsr=%o, errors=%o\n", 
				dserrs[erno], 
				dserr.dma_csr & ((u_short) -1), 
				dserr.asc_csr & ((u_short) -1),
				dserr.errors & ((u_short) -1));
			if( verbose)
				printf(" aborted\n");
			if (close(adcfid) < 0)
				perror("close");
			free((char *) dsbuf);
			return(-1);
			}
		if (verbose) printf("!\n");
		}
	if (close(adcfid) < 0)
		perror("close");
	free((char *) dsbuf);
	return(0);
}
