/* interact.c	1.2	(CARL)	5/17/85	18:32:14 */
#include <stdio.h>
#include <ctype.h>
#include <carl/sndio.h>
#include <sfheader.h>
#include "play.h"

char bufsav[BUFSIZ], *doit;
char shellstr[BUFSIZ];
extern int segmod;
extern int verbose, wizard;

#define SECONDS 's'
#define SAMPLES 'S'
#define MSECS 'm'
#define MINS 'M'
int pisfmt = SECONDS;

interact()
{
	extern char *strcpy();
	double arg; 
	extern float eval();
	static char last, *c;
	int inc, dir = 0, one = 1;
	char *index();
	float timefac;	/* must be float for eval() */
	char buf[BUFSIZ], *argp;
	int fil = 0;
	int sfd;

	sfd = pf[fil].sfp;
	timefac = SFSRATE(pf[fil].header) * SFCHANS(pf[fil].header);
	if (pf[fil].incr != 0.0) 
		inc = pf[fil].incr;
	else {
	    inc = timefac/10;	/* tenths of seconds */
	    inc = inc - (inc % SFCHANS(pf[fil].header)); /* reallign to sample frame */
	    pf[fil].incr = inc;
	}
	while (one) {
		bufclr(buf, BUFSIZ);
		setsize(fil);
		timefac = SFSRATE(pf[fil].header) * SFCHANS(pf[fil].header);
		pistat(1, fil, timefac); /* sfd bad */
		if (fgets(buf, BUFSIZ, stdin) == NULL)
			return(0);
		*index(buf, '\n') = NULL;	/* zap the return */
		if(*buf == NULL)
			continue;
		if (!strcmp(buf, "!!")) 
			strcpy(buf, bufsav);
		else
			strcpy(bufsav, buf);
		if (buf[0] == '!') {
			if (buf[1] != NULL) /* a shell command */
				strcpy(shellstr, buf+1);
		}
		if ((doit = index(buf+1, '!')) != NULL) {
			if (doit+1 != NULL) /* a shell command */
				strcpy(shellstr, doit+1);
			*doit = NULL;
		}
		for (dir = 0, c = buf; *c != NULL; c++) {
			switch (*c) {
				case '>': dir++; 
					if (c != buf) *c = ' '; 
					argp = c+1; 
					break;
				case '<': dir--; 
					if (c != buf) *c = ' '; 
					argp = c+1; 
					break;
				default:  break;
			}
		}
		if (dir && *argp != NULL) 
			inc = eval(fil, argp, timefac);
		else 
			argp = buf+1;
		if (*argp == '=') 
			argp++;
		compress(buf);		/* squeeze out whitespace */
		switch (*buf) {
			case '.': case '+': case '-':
			case '0': case '1': case '2': case '3': case '4':
			case '5': case '6': case '7': case '8': case '9':
				/* single arg, to change last set value */
				arg = eval(fil, buf, timefac);
				switch (last) {
				    case 'D': strcpy(pf[fil].convover,buf); 
					      break;
				    case 'F': pf[fil].fltover = 
						eval(fil, argp, 1.0); 
						last = *buf; break;
				    case 'R': pf[fil].srover = arg/timefac; 
					      break;
				    case 'b': pf[fil].begin = arg; break;
				    case 'd': pf[fil].end = pf[fil].begin+arg; 
					      break;
				    case 'e': pf[fil].end = arg; break;
				    case 'i': inc = arg/timefac; break;
				    case 'q': pf[fil].silence = arg/timefac; 
						break;
				    case 'r': pf[fil].repeat = arg/timefac; 
						break;
				    default: printf("???\n");
				    }
				break;
			case 'B': if (!wizard) break;
				pf[fil].bno = eval(fil, argp, 1.0); 
				break;
			case 'C': if (!wizard) break;
				pf[fil].cnt = eval(fil, argp, 1.0);
				break;
			case 'D': strcpy(pf[fil].convover,argp); 
				last = *buf; break;
			case 'F': pf[fil].fltover = eval(fil, argp, 1.0); 
				last = *buf; break;
			case 'I': playinc(sfd, fil, inc); break;
			case 'R': pf[fil].srover = eval(fil, argp, 1.0);
				last = *buf; break;
			case 'b': if (dir) pf[fil].begin += dir*inc;
				else 
					pf[fil].begin =eval(fil, argp, timefac);
				last = *buf; break;
			case 'd': if (dir) pf[fil].end += dir*inc;
				else if (*argp == '$')
					pf[fil].end = pf[fil].size;
				else 
					pf[fil].end = pf[fil].begin 
						+ eval(fil, argp, timefac);
				last = *buf; break;
			case 'e': if (dir) pf[fil].end += dir*inc;
				else if (*argp == '$') 
					pf[fil].end = pf[fil].size;
				else 
					pf[fil].end = eval(fil, argp, timefac);
				last = *buf; break;
			case 'f':
				if (!strcmp("S", argp)) pisfmt = SAMPLES;
				else if (!strcmp("s", argp)) pisfmt = SECONDS;
				else if (!strcmp("ms", argp)) pisfmt = MSECS;
				else if (!strcmp("m", argp)) pisfmt = MINS;
				break;
			case 'i': inc = eval(fil, argp, timefac);
				/* reallign to sample frame */
				inc = inc - (inc % SFCHANS(pf[fil].header));	
				last = *buf; break;
			case 'n': 
				if (segmod) {
					printf( "warning, segments modified and not written.\n");
					segmod=0; break; 
				}
				pf[fil].incr = inc;
				if (fil+1 >= MAXFILES)
					break;
				if (pf[fil+1].sfp != NULL) { /* Not good */
					fil++;
				}
				break;
			case 'p': 
				if (segmod) {
					printf( "warning, segments modified and not written.\n");
					segmod=0;
					break;
				}
				pf[fil].incr = inc;
				if (fil <= 0)
					break;
				if (pf[fil-1].sfp != NULL) { /* Same */
					fil--;
				}
				break;
			case 'q': pf[fil].silence = eval(fil, argp, 1.0); break;
			case 'r': pf[fil].repeat = eval(fil, argp, 1.0);
				last = *buf; break;
			case 's': if (ediseg(buf+1, sfd, fil)< 0) 
					fprintf(stderr, "ediseg failed.\n");
				break;
			case 'v': verbose = eval(fil, argp, 1.0); break;
			case 'w': 
				wizard =  wizard ? 0 : 1; 
				printf("wizard mode ");
				if (wizard) printf("set.\n");
				else printf("reset.\n");
				break;
			case 'x':	/* exit */
				return(0);
			case '>':	/* advance in file by increment */
				pf[fil].begin += dir*inc;
				pf[fil].end += dir*inc;
				break;
			case '<':	/* rewind in file by increment */
				dir = -dir;
				pf[fil].begin -= dir*inc;
				pf[fil].end -= dir*inc;
				break;
			case '!': 
				doit= (char *) 1; 
				break;
			case 'E':
				arg = eval(fil,argp,1.0);
				if (arg >= MAXFILES || arg < 0) {
					printf("Entry number out of range\n");
					break;
				}
				pf[fil].incr = inc;
				if (pf[(int) arg].sfp != NULL) 
					fil = arg;
				else
					printf("No soundfile in that slot\n");
				break;
			case 'L':
				dolist();
				break;
			default:
				interhelp();
		}
		sfd = pf[fil].sfp; /* Not good */

		if (!wizard) {
#ifdef NOEXTRA
			if (pf[fil].end > pf[fil].size) 
				pf[fil].end = pf[fil].size;
#endif
			if (pf[fil].begin < 0) pf[fil].begin = 0;
		}

		if (doit) {
			int ret;

			if((ret = playi(fil)) >= 0)
				fil = ret; /* Reset current file */
		}
		bufclr(shellstr, BUFSIZ);
	}
	return(0);
}

bufclr(buffer, size)
	char *buffer;
	int size;
{
	register long i;
	for (i = 0; i < size; i++)
		buffer[i] = 0;
}

compress(buf)
	char *buf;
{
	register char *c;
	for (c = buf; *c != NULL; c++)
		if (!isspace(*c)) *buf++ = *c;
	*buf = NULL;
	}

pistat(prompt, fil, timefac)
	int prompt; int fil; float timefac; /* sfd bad */
{
		printf("(%d) %s: ", fil,pf[fil].cfile);
		switch (pisfmt) {
		    case SECONDS:
			printf("b=%6.5fs ", pf[fil].begin/timefac);
			printf("e=%6.5fs ", pf[fil].end/timefac);
			break;
		    case SAMPLES:
			printf("b=%dS ", pf[fil].begin);
			printf("e=%dS ", pf[fil].end);
			break;
		    case MSECS:
			printf("b=%6.5fms ", pf[fil].begin/timefac*1000.0);
			printf("e=%6.5fms ", pf[fil].end/timefac*1000.0);
			break;
		    case MINS:
			printf("b=%6.5fm ", (pf[fil].begin/timefac)/60.0);
			printf("e=%6.5fm ", (pf[fil].end/timefac)/60.0);
			break;
		    default:
			break;
		}
		printf("R=%6.3f ", pf[fil].srover);
		printf("r=%d ", pf[fil].repeat);
		printf("q=%d ", pf[fil].silence);
		printf("D=%s\n", pf[fil].convover);
	if(prompt)
		printf("* ");
}

char *help[] = {
	"x (or Control-D)  - exit play",
	"[e,b,d]=N - set [end,begin,duration] time to N",
	"N   - change last altered parameter to N",
	"[e,b,d][>,<][N] - move [e,b,d] [ahead,back] by N",
	"	or if N is missing, by increment",
	"!   - play the file",
	"!P Command  - PIPE the current window to the commad", 
	"!R Name  - READ in the named file",
	"!A Name  - APPEND current window to named file",
	"!W Name  - WRITE current window to named file",
	"! Command  - Execute a UNIX command",
	"n   - and go on to next file",
	"L   - list sound files playable",
	"E=N - set soundfile to entry number N",
	"p   - go back to previous file",
	"r=N  - repeat N times",
	"[>,<]*[N]   - move [ahead,back] begin/end play times by * increments",
	"i=N  - set increment to N",
	"R=N  - set sampling rate to N",
	"D=S  - set DAC channels to string S, S can be any combination of 1,2,3,4",
	"q=N  - set N seconds of silence preceeding play of the file",
	"I    - start \"fast interact\" mode",
	"Only one command per line , except '!' which may appear",
	"separately or at the end of any other command.  N is time in seconds.",
	"Expressions are allowed, use postop 'S' for sample times.",
	0
	};

interhelp()
{
	char **cp;
	for(cp = help; *cp; cp++)
		puts(*cp);
}

dolist()
{
	/* list all files in play list */
	int fil;
	float timefac;

	for(fil = 0; pf[fil].sfp != NULL; fil++) {
		setsize(fil);
		timefac = SFSRATE(pf[fil].header) * SFCHANS(pf[fil].header);
		pistat(0,fil,timefac);
	}
	printf("\nCurrent file:\n");
}
