.hy 14
.ds CF
.TL
A Useful Way to Write Tutorials About Computer Programs
.AU
F. Richard Moore, Director
.AI
Computer Audio Research Laboratory
Center for Music Experiment, Q-037
University of California, San Diego
La Jolla, California  92093
.PP
Computer programs are useful to people other than their authors only if
their use is adequately explained.
The 
.UX
operating system is based on the notion of linking together several
simple programs to create complex effects.
Its documentation scheme is arranged, therefore, around manual "pages"
which define these "simple" programs in a concise way.
.PP
Some tasks, such as music synthesis, require programs more complex
than a typical
.UX
program.
The documentation of such programs cannot reasonably be put into a few
words.
The typical
.UX
convention in this case is to combine a brief manual page description with
a reference to a longer technical paper which describes the details.
I suggest a level scheme which can regularize the form of these
longer papers in a useful way.
Such a scheme would allow users to learn about complex programs in stages,
and in particular, it would obviate the need to read a long document in its
entirety before a simple application can be attempted.
In addition, it provides a simple and useful way to organize 
tutorial information around the needs of the reader as well as the author.
.SH
The Levels
.PP
I think there are six basic levels of documentation for complex computer
programs.
While each of these levels might be further subdivided in the case of
extremely complex programs, it is the goals of each level rather than
the complexity of the program which determines which levels are basic.
.SH
Level 0 - The Cocktail Party
.PP
Level 0 is a simplest, shortest statement of what a program does.
It may be typically only one sentence long.
It is amazing how much documentation either does not include such
a statement at all, or has it buried somewhere about two-thirds of
the way through a complex statement of operational detail.
.SH
Level 1 - The UNIX Utopia
.PP
Level 1 documentation is analogous to the 
.UX
manual page.
For a simple program, this may be all that is needed.
Here, the basic rules for using the program are stated, the operation defined
as precisely as necessary for basic use, and reminders of the most
common pitfalls and problems may be given.
.SH
Level 2 - The Casual
.PP
This level is for the casual user of a complex program.
I think of it as the "cookbook" level.
It consists primarily of annotated examples.
These examples should consist of the most straightforward and typical
uses of the program.
A description the underlying operation should be unnecessary at this
level.
.SH
Level 3 - The Involved
.PP
This is the "general proficiency" level of documentation, written for
users who may have non-trivial applications, 
who need to have a functional understanding of the program operation,
but who don't really need to understand the algorithms internal
to the implementation of those functions.
.SH
Level 4 - The Master
.PP
This level includes the fine points and esoterica, including 
a description of the algorithms used to make the program work.
This is the "expert user" level, but does not include information
about the implementation of the program as such.
.SH
Level 5 - The Wizard
.PP
This level consists of a technical explanation of the operation of
a program for the benefit of those who may wish to write a similar
program of their own, including features of the design.
I think of it as the "implementation level", as it is likely to
concern only those who wish to implement other, or similar, programs
on other, or similar, systems.
.SH
Level 6 - The Ultimate
.PP
The final document for any program is itself.
A program written in a high-level language such as C should be self-documenting
in the sense that it includes enough comments to make it readable by
an expert.
It does not have to be self-documenting to a user at or below level 4,
but it should complement the knowledge of a level 5 user.
.SH
Organization of Tutorials
.PP
Computer documentation tends to become an amorphous mass of detail,
especially to a nonspecialist user, and I expect that a top-down organization
will almost always be the best.
It allows readers to stop when they have found out enough, and to stop
much sooner than is typically possible with a non-hierarchical document.
It encourages readers to continue if they haven't satisfied
their requirements by reading up to a certain point.
It allows the author to rely on information already given in
previous levels when writing about successively more complex things
(reading the "bird's eye" view first minimizes the likelihood of later
disorientation in the midst of details).
Finally, it makes explicit, for both the reader and the author, what
information pertains to superficial understanding, casual usage,
standard application, expert exploitation, and aesthetic appreciation.
.PP
For very simple programs, as I have said, it may be necessary only to go down
to level 1 documentation.
This is the utopian
.UX
model, in which the difference between level 1 and level 6 is so small
that the intermediate stepping-stones are unnecessary - the program
is hardly more complex than its explanation.
For more complex programs, though, the levels should be addressed in
one or more documents which are mentioned in the level 1 writeup.
The major feature of this documentation must be to make the level
of each of its sections 
.I explicit.
.PP
From the author's point of view, it may be desirable to write levels
2, 3, and 4 together, but from the reader's standpoint, I suspect
that it is likely to be much more educationally efficient to go
through level 2 from beginning to end before reading about level 3,
and so on.
This suggests a serial arrangement by level, even though a document
might not be written in this order.
It may be desirable to quarantine level 5 documentation in a separate
writeup, since it clearly affects only colleagues, not customers,
and there will always be more of the latter than the former if the
documentation is properly written.
