.TL
Notes on Installing Software for the CMD Audio Switch
.AU
Gareth Loy
.AI
CARL
.PP
Left out of the treatment of installing the CMD Audio Switch in the
other documentation is the subject of the device driver.
.PP
The interface is via a DEC DR11-C, which uses a modified
UNIX ct device driver.  The ct driver is set up for the CAT
Phototypesetter, a byte-oriented device, whereas the CMD is a
word-oriented device.  So one modification is to write words
to the device.  Another modification is that the CMD never generates
interrupts, so no interrupt handler is necessary.  Furthermore,
there is the need of a special ioctl() call to do a 
reset of the CMD hardware.
.PP
The device driver is still called /sys/vaxuba/ct.c, but has another
file, /sys/vaxuba/asw.h which supplies the macro for it.  (This 
file should also appear in /usr/include/vaxuba, and is required
when recompiling aswdaemon.)
.PP
A sample entry in /sys/vax/conf.c is:
.DS
#ifdef CARL
#include "ct.h"
#if NCT > 0
int	ctopen(),ctclose(),ctwrite(),ctioctl();
#else !NCT
#define	ctopen	nulldev
#define	ctclose	nulldev
#define	ctwrite	nulldev
#define	ctioctl	nulldev
#endif NCT
#endif CARL
.DE
.PP
.DS
#ifdef CARL
	ctopen,		ctclose,	nodev,		ctwrite,	/*18*/
	ctioctl,	nodev,		nulldev,	0,
	seltrue,	nodev,
#else !CARL
.DE
.PP
And the entry in /sys/conf/SYSNAME is
.DS
device		ct0	at uba? csr 0167760 flags 0x0	vector ctintr
.DE
.PP
Also, ct0 must appear in /dev, to wit:
.DS
crw-rw-rw-  1 root      18,   0 Aug 29 10:52 /dev/ct0
.DE
.SH
SELECTED PORTIONS OF THE DRIVER
.PP
.nf
.na
.DS
/* ct.c	1.2	(CARL)	8/10/84	12:54:42 */

#include "ct.h"
#if NCT > 0
/*
 * DR11C driver used for CARL CMD Audio Switch
 */
#include "../machine/pte.h"

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/map.h"
#include "../h/uio.h"
#include "../h/buf.h"
#include "../h/conf.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/kernel.h"

#include "../vaxuba/ubareg.h"
#include "../vaxuba/ubavar.h"
#include "../vaxuba/asw.h"

#define bit(n)	((1) << (n))

#define CT_CSR1		bit(1)

#define	PCAT		(PZERO+9)
#define	CATHIWAT	100
#define	CATLOWAT	30

union ctword {
	short	un_word;
	char	un_bytes[2];
};

struct ct_softc {
	int	sc_openf;
	union	ctword sc_word;
	int	sc_pos;
} ct_softc[NCT];

struct ctdevice {
	short	ctcsr;
	short	ctbuf;
};

int	ctprobe(), ctattach(), ctintr();
struct	uba_device *ctdinfo[NCT];
u_short	ctstd[] = { 0 };
struct	uba_driver ctdriver = { ctprobe, 0, ctattach, 0, ctstd, "ct", ctdinfo };

#define	CTUNIT(dev)	(minor(dev))

ctprobe(reg)
	caddr_t reg;
{
	register int br, cvec;		/* value-result */
	register struct ctdevice *ctaddr = (struct ctdevice *) reg;

#ifdef lint
	br = 0; cvec = br; br = cvec;
	ctintr(0);
#endif
	ctaddr->ctcsr = IENABLE;
	DELAY(10000);
	ctaddr->ctcsr = 0;
	return(sizeof (struct ctdevice));
}

/*ARGSUSED*/
ctattach(ui)
	register struct uba_device *ui;
{
	return(0);
}

ctopen(dev)
	dev_t dev;
{
	register struct ct_softc *sc;
	register struct uba_device *ui;
	register struct ctdevice *ctaddr;

	if (CTUNIT(dev) >= NCT)
		return(ENXIO);
	if ((ui = ctdinfo[CTUNIT(dev)]) == 0)
		return(ENXIO);
	if (ui->ui_alive == 0)
		return(ENXIO);
	if ((sc = &ct_softc[CTUNIT(dev)])->sc_openf)
		return(ENXIO);

	sc->sc_openf = 1;
	sc->sc_pos = 0;
	sc->sc_word.un_word = 0;
	((struct ctdevice *) (ui->ui_addr))->ctcsr = CT_CSR1;

	return (0);
}

ctclose(dev)
	dev_t dev;
{
	ct_softc[CTUNIT(dev)].sc_openf = 0;
}

ctwrite(dev, uio)
	dev_t dev;
	struct uio *uio;
{
	register struct ctdevice *ctaddr;
	register struct ct_softc *sc;
	short word;
	int error;

	sc = &ct_softc[CTUNIT(dev)];
	ctaddr = (struct ctdevice *) ctdinfo[CTUNIT(dev)]->ui_addr;

	while (uio->uio_resid) {
		if ((error = uiomove((caddr_t) &word, sizeof(word), UIO_WRITE, uio)))
			return(error);

		ctaddr->ctbuf = word;
	}

	return(0);
}

ctintr(dev)
	dev_t dev;
{
	printf("ct%d: interrupt\\n", CTUNIT(dev));
}

/* ARGSUSED */
ctioctl(dev, cmd, addr, flag)
	dev_t dev;
	caddr_t addr;
{
	register struct uba_device *ui;

	ui = ctdinfo[CTUNIT(dev)];

	switch (cmd) {
		case ASW_RESET:
			((struct ctdevice *) (ui->ui_addr))->ctcsr &= ~CT_CSR1;
			((struct ctdevice *) (ui->ui_addr))->ctcsr |= CT_CSR1;
			break;

		default:
			return(ENOTTY);
			break;
	}

	return(0);
}
#endif
.DE
