.TL 
MANAGING A CSOUND TAPE DUMP REGIMEN
.PP
.SH 
INTRODUCTION
.PP
The
.I csound
system provides hooks for managing a dump procedure similar to that
of the UNIX program 
.B dump.
.B lsf(1csound)
provids a mechanism to determine which files to dump, 
.B dumpsf
actually does it.
.PP
A 9 level dumping regimen is supported, with level 0 as longest term
and most inclusive, level 9 as most frequent and least inclusive.
Each site will have different requirements, but the following should
constitute a useful initial approximation as to how to manage a dump
regimen.
.PP
Dump levels 0 to 4 should be treated as permanent dumps and kept in a
tape archive.  Because they are done relatively infrequently, they
only get the files which linger on longest, which
tend to be the most important ones (as far as the system is concerned,
that is.  Users who wish to protect their own files may do so on their
own).  
Dump levels 5 to 9 should be treated
as temporary, and the tapes should be recycled.  Temporary dumps are
insurance against short-run losses of data on disks.
.PP
The purpose of a permanent archive is to have several copies of important
files on different tapes to guard against the ravages of time, whereas the
purpose of temporary dumps is to have just one copy of every file, even
the highly transient ones.
A relatively simple strategy to accomplish this is 
to intersperse permanent dumps inbetween temporary ones.
We will examine strategies for such a sequence below.
.PP
The rule for a dump level is that each dump will contain only files which
have been created or changed since the next-lower-level dump was done.
.B lsf(1csound)
has flags, -1 ... -9 which will print the files which should be dumped
at the level specified by the flag.   The command
.DS
% lsf -5 /snd
.DE
will list all files to dump at level 5.  It does this by referencing the
file /snd/sfdumpinfo (which is created and managed by 
.I dumpsf(1csound))
to find the date of the next-lower-level dump, which it then compares to
the last-altered date of all files on /snd.  Note, since level 0 dumps
include all files on a file system, there is no -0 flag for lsf, simply
say
.DS
% lsf /snd.
.DE
The files so listed can be passed to the standard input of
.I dumpsf
.DS
% lsf -5 /snd | dumpsf -5.
.DE
.SH 
DUMPING SEQUENCE 
.PP
The following dump sequence optimizes to maximize the number of copies of files
on permanent dumps, and to reduce the number of copies on temporary dumps.
.PP
The sequence for temporary dumps is to start at 5, the next day 6, then
7, 8 and 9.  Thus, during the temporary dump sequence,
each day's dump only gets the files which have changed
since the previous day.  
.PP
The sequence for permanent dumps can be, for instance 
.DS 
0 4 3 4 2 4 3 4 1 4 3 4 2 4 3 4 0 ...
.DE
.PP
The combined strategy would be:
.DS
0 {5,6,7,8,9}, 4 {5,6,7,8,9}, 3 {5,6,7,8,9}, 4 {5,6,7,8,9} ...
.DE
.SH
OTHER CONSIDERATIONS
.PP
.I dumpsf
can't handle files that occupy more than one cylinder.  They must be broken
up into tape-sized pieces.  Thus, it is wise to estimate the size of
the dump first, which can be accomplished by
.B dumpsf's
-e flag:
.RS .5i
% lsf -5 | dumpsf -e
.RE
which checks for file fit and computes the total number of tapes required.
If you need more specific information on what goes where on a dump tape,
add -v to 
.B dumpsf.
If a file is too long and you simply want to ignore it, redirect the output
of 
.B lsf
to a file and delete the filename.  Then redirect the standard input of
.B dumpsf
to come from this file.
