.RT
.DS C
Installation of the CARL Software Distribution
.DE
.LP
We have tried to make the installation of this software
as straightforward as possible.
To do this we have used the \fIm4\fP macro processor in
conjunction with \fImake\fP.
.LP
The makefiles typically have the destination directories and
pathnames to the libraries embedded in them, changing all of
the makefiles would normally be a chore.  What we have done
is to have a ``master makefile'' that has m4 macros in it
for defining the directories, libraries, etc.  and have the
definitions for these macros in one file.
All of the makefiles include a ``configuration'' 
file which defines the macro names
used in the master makefiles.
Each program has its own master makefile, and a ``super makefile''
for all of the sources runs m4 on each of the master makefiles
producing the makefile that \fImake\fP uses.
.LP
What follows are the steps that must be followed to install
it.
.IP \(bu
The configuration file is named
\f(TYinclude/carl/config.m4\fP.   It has all of the definitions for
the destination directory, libraries, and other site-specific
information.  It should be edited to reflect your installation.   Note
that because this file is used by \fIm4\fP that any macros that
\fIm4\fP recognizes must be quoted; in particular you will see
lines of the form
.DS I
\f(HRinclude(/usr/``include''/carl)dnl\fP
.DE
the double set of quotes around the word \f(HRinclude\fP prevent
\fIm4\fP from interpreting it as an \fIm4\fP command.   Normally only one
set of quotes would be needed but because the macros in this
file are seen twice two sets of quotes must be used.
.IP \(bu
After editing \f(TYinclude/carl/config.m4\fP it should be placed someplace.
At CARL we have a local directory for all include files,
\f(TY/usr/include/carl\fP,
and have placed it there.   
If you specify a different target location for CARL include files in 
\f(TYinclude/carl/config.m4\fP, a script \f(TYfixmakefiles\fP will
be executed to change all Makefile.m4 files to refer to the place
you have specified.
NOTE: it is highly recommended to usr \f(TY/usr/include/carl\fP,
as otherwise another step must be done manually to change many of the
include statements in the program sources, as described below.
.IP \(bu
The manual pages need a little attention.  
Installation of manual pages is done by the Makefile in \f(TYman/manc\fP.
Before running that makefile, however edit the file
\f(TYman/manc/srcvt\fP.  This 
is a shell script that will fix the documentation to reflect the sampling
rates of your system.   Modify it to reflect local values.
This script is run on the manual pages after they are
copied to their target directory, so the manual page sources are not
changed.  
.IP \(bu
At this time you should be ready to make everything.
There are two basic steps: fix up \f(TY./include/carl/config.m4\fP
to reflect your local situation, and run \f(TYmake\fP.
The first time you attempt the installation, you should say
.DS
make -f Makefirst
.DE
which makes the master Makefile, runs a cleaner over the directories
to force rebuilding of everything, then executes make on the
master Makefile.
First, read the rest of this document.
.LP
At this moment, if you want to put CARL include files anywhere besides
\f(TY/usr/include/carl\fP
you will have to modify all .c and .h files so that any reference
to \f(TY<carl/...>\fP is changed to \f(TY<wherever/...>\fP.  This
can be done with a combination of find and sed, such as the following,
which changes all instances of 
.br
\f(TY<carl/\fP
.br
to
.br
\f(TY<local/carl/\fP.
.br
find . \\( -name '*.h' -o -name '*.c' \\) -exec 
sed "s:<carl/:<local/carl/:" {} > /tmp/xxx \\; -exec 
mv /tmp/xxx {} \\;
.br
(The foregoing was a single command.)
This would convert define statements in .c and .h files of the form
.br
# include <carl/carl.h>
.br
to
.br
# include <local/carl/carl.h>.
.br
.\" if you are looking at this with a text editor, you should
.\" remember that there's one level of `\' in the above that you
.\" would leave out to execute the find command.
You might want to try your luck with the shell script 
\f(TYfixinclude\fP in this directory.
.LP
The file include/carl/defaults.h contains default values for many of
the programs, including the default sampling rate for the DSC converters.
Edit and modify this program as required, but read the next paragraph first.
.LP
If your version of UNIX did not come with a file named
\f(TY/usr/include/whoami.h\fP,
(Berkeley seems to have taken this file out of their standard release
for some obscure reason), you can use this one:
\f(TYinclude/whoami.h\fP.  Put it in \f(TY/usr/include\fP.
It is supposed to contain a
macro definition that is the name of your system.  
This file is included by any CARL programs that need to know the 
particular hardware environment of your site.  
For instance, the file include/carl/defaults.h has one set of
values used at CARL, and another set used at IRCAM.
By saying
.br
# ifdef CARL
.br
 ...
.br
# endif CARL
.br
such site-specific code has been isolated.
The easiest way to install CARL software is to pretend that you are at CARL,
and use the whoami.h and defaults.h files as they are.  If that is not
possible (e.g., if your converters run at a different rate), 
the next easiest thing to do is to still pretend you are at CARL,
and just change the values in defaults.h that you must.
The most general approach is to copy the code that depends on the
macro CARL, change it to depend on your own site's name, and change
the site name definition in whoami.h.
.PP
Although we've tried to remove all system dependencies we've probably
overlooked some or have been unable to automate everything.  For example
the cmusic makefile will need to be edited so that it doesn't compile
in the csound stuff if you don't use csound.
