.TL
CSOUND - CARL SOUND FILE SYSTEM
.AB
This paper discusses the implementation of the CARL Sound File System, 
the main purpose of which is to enable sound waveform
data to be efficiently stored on contiguous cylinders of disk
mass storage systems, to facilitate realtime data transfer.
[Note, this paper is outdated with regards to the structure of
the sfstab database, and contiguous/non-contiguous defaults have
been switched so files default to being contiguous now.]
.AE
.NH
DESIDERATA
.PP
There are two reasons for having a file system separate from
the 
.UX 
file system for sound waveform
data.  The first is that the regular UNIX file system does not allow for
contiguous placement of file data on a disk.  (That is, the data from one
file is fragmented across the disk.)
Thus, realtime data transfer
at speeds exceeding the worst case disk head seek time could be
forced to drop out of realtime.
The only sure cure for this is to cause the data to occupy
physically adjacent storage blocks on the disk, minimizing seek time.
.PP
The second reason for the separate file system is that there is a quantity
of characteristic information about sound files that must be maintained with
the sound data itself, such as sampling rate, number of channels, data
packing format, and so on.  This information must be tightly coupled with
the sound, but must be kept physically separate.
.PP
The smallest file in the 
.I csound 
system is an entire cylinder.
On a CDC 9766, a 300MB pack, one cylinder stores 311296 bytes of data.
Even though this is a lot
of bytes, it is not a lot of sound.  At a 50 KHz sampling
rate, mono, using 16 bit samples, it's a little over 3 seconds,
so the unit interval is not made to be unmanageably large by this.
.PP
The user interface to this sound file system
has been made to utilize standard UNIX conventions insofar as possible.
Even where there are differences, they have been done insofar as possible
within the "spirit of UNIX".  Perhaps the best evidence of the success of
this project is that 
there are no modifications to the UNIX Kernel required to implement this
file system on version 7 UNIX.
.PP
At the user level, a set of programs are provided to do the basic functions
of creating files,
accessing files, observing files, moving and deleting files, as well as
playing and recording them.
Other programs dump and restore files to and from tape, fix a broken file
system, compact free space and purge user files.
.PP
These programs rely on standard UNIX i/o routines driven by
a library of routines that make up the core of the csound system.
.NH
CONTIGUOUS AND NON-CONTIGUOUS FILES
.PP
In signal processing tasks that are
not time-critical (essentially anything except playing and recording), 
flexibility of file size is more important than speed of access.
So a non-contiguous file mode has been provided as well as contiguous.
Non-contiguous files have a (possible) list of cylinder blocks.
When creating a file for which one does not know the final dimensions,
one can either claim the largest contiguous block, or declare the file
non-contiguous.  Non-contiguous
files can grow automatically out to the limit of the 
free storage and have the advantage of being able to fill up all the cracks
in between contiguous files.
Their drawback is that 
for reasons of head latency, the disk might not be able to play them
without gaps.  (The current implementation of 
.B play 
does not allow playing non-contiguous files because of limitations
in the
.B ds
driver).
This reasoning leads to contiguous files
to be called "realtime" files sometimes, and non-contiguous files
to be called "non-realtime" files.
Under ordinary circumstances, 
one uses contiguous files for everything.  Non-contiguous files are used if
1) there is no one block of free storage available big enough to hold the
required data, but there is enough fragmented storage available, 2) one does
not know in advance how much space will be required. 
As an alternative to (1), there is a program 
.B (burpsf) 
to condense fragmented free storage into one block. 
.PP
Copying a file with 
.B cpsf 
automatically converts a non-realtime file into
a realtime one.
Because the size of a contiguous sound file is fixed, it must
be supplied at the moment
it is created.  
.NH
HARDWARE LEVEL
.PP
The disk to contain the 
.I csound 
file system
and its driver are formatted to contain at
least two partitions: one small one of 2 cylinders
for a regular UNIX file system
for bookkeeping, the other, usually occupying the rest of the disk,
for sound file storage.  A file system is mounted on the small
partition with names such as /snd, /snd1, etc.
It is mounted as a subdirectory of root ( / ),
and contains a free space database file, possibly a lock file, and one
additional subdirectory for each user of the filesystem.  Within these
subdirectories are Sound Descriptor Files (SDF) and possibly other
subdirectories with more SDF files.
The whole directory is called the SDF directory.
.PP
The SDF directory is managed entirely by the 
.I csound 
file system.  All
subdirectories and files are owned by a pseudouser named disk.  All
csound programs that create or alter SDF files (including 
.B sndin 
and 
.B sndout
for example) are also owned by disk, and have the Set-User-Id bit
set, so that they may acces the SDF files.
.PP
Another file, called sfstab, and not kept on any SDF directory,
contains a list of all csound filesystems.
At CARL this file is
called /carl/lib/sfstab.  This file behaves
somewhat like /etc/fstab.  The entries are in the format:

.DS
<directory>:<raw_device>:<read/write_mode>:<#_of_blocks>:<dev_number>:
	<bytes_per_track>:<lock_file>:<bytes_per_block>
.DE
The meaning of the fields is discussed below.
For example, here is the sfstab at CARL:
.DS
/snda:/dev/rra0f:rw:1246:2:26112:/snda/lock:365568:
/sndb:/dev/rra1f:rw:1246:3:26112:/sndb/lock:365568:
/sndc:/dev/rra2f:rw:1246:4:26112:/sndc/lock:365568:
/snd1:/dev/rup1f:xx:821:1:16384:/snd1/lock:311296:
/snd2:/dev/rup1f:rw:821:1:16384:/snd2/lock:311296:
/snd3:/dev/rup1f:xx:821:1:16384:/snd3/lock:311296:
/snd4:/dev/rup1f:xx:821:1:16384:/snd4/lock:311296:
/snd5:/dev/rup1f:xx:821:1:16384:/snd5/lock:311296:
.DE
/sndN (where N is a number) are removable packs that all go on
one drive (up0), which we call a UDP (user disk pack).  
That is why they all have the same <dev_number> field value.
/sndX (where
X is a letter) are winchesters (DEC RA-81's), with 26112 bytes per
track, and 365568 bytes per cylinder.
The 
.I readwrite 
mode can be rw, rx, (or wx), or xx, meaning read/write,
read-only, (write-only!), and lastly, no access.  
.I size 
is the
number of cylinders in the raw device.  
.I dev_number 
has two uses: as
an index into an internal table managed by 
.B opensf(3csound) 
that keeps
statistics about open raw devices, and also by the UNIX driver for
Digital Sound Corp.  System 200 converters documented in 
.B ds(4).  
The
.I dev_numbers 
for successive lines must increase monotonically from 0 for all
file systems that are mounted on different physical drives, and
must agree with the device numbers compiled into the 
.B ds 
driver (if
you have DSC converters).  The value of the macro NSFSYS, defined in
libsf.h must be >= the number of file systems shown in sfstab.
.PP
When a pack is changed, the SDF directory
on the packs must be changed with the csh(1) shell scripts
.B mountsf
and
.B umountsf.
All packs to be mounted on a particular drive
should be formatted with the same number and position of cylinders.
If you are mounting a differently formatted pack, you must modify sfstab.
The sound sample partition
is not mounted, merely opened in raw mode by the 
.I csound 
program at the appropriate moment to do sample i/o.
.PP
The name of the SDF directory should be written
on the pack label to facilitate knowing what to mount.
Make sure that the /snd directory has the appropriate protections.
If you are implementing a multi-drive system, the convention is to name
successive sound file systems /snd1,... /sndN.
.PP
Note: when setting up sfstab for the first time, it is possible to make
the block size equal to a track.  Althought this has never been tried,
there is no reason it should not succeed.  This will reduce the amount
of wasted space due to small files, but will increase the overhead of
claiming/releasing blocks.
.PP
The way these parts work together is as follows.  In this and
all subsequent examples, we will assume we are dealing with contiguous files.
When a file is created,
the steps which take place are to 1) examine the free list to find out where
on the disk we can put the file, the space is then marked as ALLOCATED; 
2) make up an SDF describing the file and write it in the SDF
subdirectory of the user creating the file;
In loose terms, the SDF file acts like the UNIX
i-node.
.SH
The Disk Cylinder Free List
.PP
The cylinder free list maintains an image of where the sound data 
is on the disk.  It is organized into blocks of cylinders.  For contiguous
files, all sound data appears in one block.  For non-contiguous files,
the sound data may be spread over one or more blocks.  In this case, a
sequence number is used to keep track of the order.
.DS
flag	base	len	date	sequence#	filename
.DE
.PP
.I base 
is the cylinder address relative to the beginning cylinder of
the raw sound storage device.  
.I len 
is the number of cylinders in
the block.  
.I date 
is the creation date of the file using this block.
The 
.I sequence 
number gives the succession of blocks in the file.   
If the file is contiguous (realtime), the sequence number will be -1,
otherwise the sequence numbering starts from 0.  
.I filename
is the name of the file.
.PP
The 
.I flag 
field is one of the following characters:  
.DS
.nf
USED 			u
UNUSED 		n
ALLOCATED 		a
FREED 		f
.DE
which are the four states that any cylinder block may have.
When cylinders are first claimed, 
the affected cylinders are marked ALLOCATED.
These are changed to USED when the file is closed. 
When USED or ALLOCATED cylinders are returned to the free list, 
they are marked FREED until the file is actually deleted, 
at which time they are marked UNUSED. 
The allocation routines will not touch any cylinders 
with either USED,  ALLOCATED or FREED status.  
.SH
SOUND DESCRIPTOR FILES
.PP
These are called SDF for short.
They record configuration information about the sound samples, and
point to the actual file data.  They are the primary carriers of information
about the state of the filesystem.  For instance, if 
the free list gets broken, it is rebuilt by consulting the SDF files.
An SDF is a text file the name of which is taken
as the name of the sound file.  The SDF files live in the user-named
subdirectories of an SDF directory.  They have the suffix ".sdf" at CARL.
The format of lines in SDF files is:
.DS
<key> <space> <value> [... <value>] \n
.DE
The <key> is a single letter.  These letters have been chosen such that
they agree with the flag names in the program
.B sndout
used to set the attributes of a sound file.
Here is a sample SDF named /snd/dgl/test.sdf.  
The comments in /* ... */ do not appear in the files.
.DS L
t r				/* is file realtime? r = yes, n = no */
C 1				/* number of cylinders in file */
p 644				/* protection code */
H S				/* file type, Scratch, Hold or Keep */
f /snd/dgl/test			/* copy of filename */
o dgl				/* file owner */
v u	1	1	0	/* disk block pointer */
R 16384.000000			/* sampling rate */
P s				/* packing mode, s = short f = float */
c 1				/* number of channels */
# 0				/* number of samples */
w 399164676			/* creation date */
x 399882993			/* last referenced date */
y 399164678			/* last altered date */
z 397787120			/* date last dumped */
k 131081			/* tape key, stores tape # of dump */
u XXX				/* proc. id. of user if file is open */
% w				/* i/o mode, if file is currently open */
r This is a comment line
r This is another comment line
I filename
I other filename
.DE
.IP
.I Protection
is as in UNIX, stored in octal, where each 3-bit digit stores
a protection code for the owner, his group, and others.  
6 = read/write permission, 4 = read-only permission, 0 = no permission.
Thus, mode 644 (the default) is owner can read/write, his group and others
can only read (meaning also that they can't delete).
.IP
.I Disk 
.I Blocks
look exactly like their counterparts in the free list file, but they
leave off the sequence number and filename.  The sequence in which they
appear is their correct order.
.IP
.I 
Sampling Rate
.R
is the per-sample rate.
.IP
.I
Packing Mode
.R
is either 
.I s 
for 
.I short
(16-bit fixed point fractional integer
samples suitable for direct conversion)
or
.I f
for
.I float
(32-bit floating point).
.IP
.I
Number of Channels
.R
is arbitrary.  However, 
.I play
and
.I record
limit them to the number of converter channels.
.PP
The '%' and 'u' lines only appear if the file is open.  The value
of '%' is the process i.d. of the user who has the file open, and
the 'u' value is the i/o mode, either 
.I
r, w,
.R
or
.I rw.
.IP
.I Comment
lines begin with 'r'.  Any number may appear, all must begin with 'r'.
.PP
Lines beginning with 'I'
point to other relevant files.
The purpose of this is similar to the  
.I C  
language
macro convention of the #include file specification.  It allows one to 
point to other files which can contain additional data about the file.
This additional information is completely unconstrained, because it
is completely irrelevant to the operation of the sound file system, 
and is intended to be used to store analysis information, or whatever.   
.IP
.I
File Type
.R
determines the latency of the file on the disk.  
In an attempt to keep as much file space available on a day-to-day basis
as possible in order to maximize the resources available to active users,
a system of automatically recycling file space has been implemented.
Newly created files have a file type of
.I Scratch.
.PP
Ordinarily, 
.I Scratch
files have a latency of 1 calendar day after the time last referenced,
.I Hold
files last 7 days after the last reference, and
.I Keep
files are not automatically recycled.
.PP
One can use the programs
.B holdsf,
and
.B keepsf
to make a file more permanent.
.B scratchsf
returns a file to 
.I Scratch 
type.
.NH
HEADER FILES
.PP
There are three header files, 
.I sndio.h, 
.I libsf.h 
and 
.I filesf.h.
.I sndio.h
contains declarations for programs that need to access the "standard
interface" for the 
.I csound 
system.  
It is installed in /usr/include/carl at CARL.
.I libsf.h
has a #include for sndio.h, and adds the needed specifications for
the library routines.  
.I filesf.h
contains other built-in pathnames used by the system.
These last two files are usually in the libsf subdirectory of
the
.I csound
sources.
.NH
SOUND FILE DESCRIPTORS
.PP
The 
.I 
Sound File Descriptor 
.R
(SFD)
is the in-core version of the Sound 
Descriptor File (SDF)
for a sound.  
This usage will be held to with a modicum of consistency throughout 
(dyslexics beware!).  When 
.B sndin 
goes to read a file,
it looks up the SDF file, and reads in the information into an SFD
structure
that stores the information for the program's use.
The SFD structure contains all the information in the 
SDF file, plus other registers needed by sndin and sndout
to do buffer management.  The descriptor as it appears in 
sndio.h looks
like this: (Note: a '~' character in the comment field
after a declaration means the declared object is only used in
the sndesc structure and is not stored in the sdf file: 
.DS L
struct sndesc
    {
    struct sndesc *nxtsdf;/* link to next sndesc structure */
    struct sndesc *lstsdf;/* link to last sndesc structure */
    char 	*sfn;	/* sound file name */
    char	*sfown;	/* owner of file */
    int		rtflag;	/* RT bit set if realtime file */
    int		fprot;	/* File protection, kept in msfd as well. */
    int		fid;	/* ~ file descriptor for /rxy0c */
    long	ncyls;	/* total number of cylinders */
    struct dskblk *cp;	/* * Pointer to linked list of disk cylinders.  
			    If rtflag !=0 then there will be but one link, else
			    each link points to a set of contiguous disk
			    cylinders. Last link has flag EOLIST, not a valid
			    block, points to first block for circularity */
    long 	cptr;	/* ~ virtual current cylinder number */
    long	secptr;	/* ~ virtual current sector number */
    long	bufsiz;	/* ~ number of BYTES in sound buffer */
    long	sbptr;	/* ~ current BYTE in sb */
    long	sbcnt;	/* ~ count of remaining BYTES in sb*/
    int		bdir;	/* ~ buffer direction: SFWRITE or SFREAD */
    int		bfvb;	/* ~ first valid byte in buffer */
    char	*sb;	/* ~ pointer to sample buffer array */
    char	*tb;	/* ~ buffer for remainder of samples that cross
    				sb boundary (writeing only) */
    int 	rw;	/* ~ SFWRITE or SFREAD, or both, plus SFOPEN */
    int 	eof;	/* ~ end of file has been reached */
    int		err;	/* ~ !=0 if error, gives error code */
    float 	sr;	/* sampling rate (samples per second) */
    int		pm;	/* packing mode of samples */
    int		nc;	/* number of channels */
    long	fs;	/* total samples in file */
    long	cdate;	/* creation date, in system date format */
    long	rdate;	/* date last referenced */
    long	adate;	/* date last altered */
    long	dumpd;	/* date last dumped */
    long	tpkey;	/* tape locator */
    char	*comment; 	/* pointer to one line comment string. */
    struct inclist *inclsdf;	/* pointer to linked list of names of files
				   in any unix fs containing additional 
				   user-supplied info about file. */
    };
.DE
.PP
When a sound file is opened with opensf() for reading, 
it
goes out and reads up the SDF file, creates a SFD 
structure and fills it with all the appropriate values, and returns it as
the result of a successful open.  This structure is equivalent in
function to a UNIX file system FILE pointer.  
.PP
When creating a new file, however, many of the fields on the sndesc 
structure must be 
set for the first time.  
The most basic routine for doing this is setsfd which allows you
to set selected fields in a sndesc structure.
.NH
SFD HANDLING ROUTINES
.PP
.nf
struct sndesc *setsfd(sfd, ctrl, arg)
	struct sndesc *sfd; char *ctrl; char *arg;
.fi
.PP
.B setsfd() 
makes a new sndesc structure if the sfd pointer is NULL. 
Successive calls to 
.B setsfd() 
with the same sndesc structure will write
into the sfd created the first time.
The 
.I sfd 
argument is the sndesc structure to be updated,  (or if NULL,
created) the 
.I ctrl 
argument specifies the key for
field on the sndesc structure to change, and 
.I arg
is the string value to use.  
.B setsfd()
can be used to stuff any field on an SFD.
If a key appears which is not recognized, the
procedure aborts and returns NULL.  
If the arguments can't be evaluated as described by their key,
setsfd also aborts.
.PP
.nf
struct sndesc *dfltsfd(sfd, ctrl, dflts, args)
	struct sndesc *sfd; char *ctrl, *dflts; char **args;
.fi
.PP
.B dfltsfd() 
takes an 
.I sfd 
and 
.I ctrl 
string like 
.B setsfd(), 
and checks the 
.I ctrl 
string against the string 
.I dflts 
for omissions, then
fills in any omissions from the remaining arguments.
There must be as many arguments as flags in 
.I dflts.
The purpose of this routine is to make sure all critical fields of a sndesc
structure are valid.  One typically reads the command line for flags to
set the non-default values, then fills in the remainder with 
.B dfltsfd().
.PP
.nf
Example call:
sfd = dfltsfd(sfd, flags, "cRPCtpf", "1", "49152.0", 
	"s", "1", "r", "0644", "test"
.fi
where 
.I flags 
is a string of all the flags collected from the command
line, and concatenated into one string.
.PP
.nf
checksfd(sfd)
	struct sndesc *sfd;
.fi
.PP
This validates a sndesc structure prior to its use in a call to 
.B opensf().
The fields on the SFD structure checked by this routine must be
set to valid values as defined above in the discussion of 
.B setsfd()
before the SFD structure can be used in a call to 
the sound file routines. 
.PP
.nf
Fields checked are:
sound file name (sfn) not NULL and strlen(sfn) > 0,
number of channels (nc) in the range of 1 to 4,
sampling rate (sr) >= 0,
packing mode (pm) == PM16BIT or PMFLOAT,
realtime flag (rtflag) == RT or NRT.
Note that the checks for pm and rtflag determine whether one mode or
the other is set, but do not check to see if both are on.
Also note that there are a lot of things NOT checked, notably there is
no check for cylinder address consistency.
.fi
.PP
The routine returns an error code if can't read the sndesc structure at all, 
otherwise it returns
an error code.  If it could read the sndesc structure and it did find an
error, it also writes an error code in sfd->err.
.PP
Using these three routines in a row virtually guarantees a valid sfd.
For an example of use of these three routines, see 
.B sfoargs(), 
the routine
that sndout uses to read the command line and open a sound file.
.NH
OPENING AND CLOSING SOUND FILES
.PP
There are two routines for opening sound files, the "system" version and
the "user" version.
.PP
.DS
struct sndesc *sopensf(name, mode, sfd)
	char *name; char *mode; struct sndesc *sfd;
.DE
.PP
This is the system version.
The name argument is the sound file name, without any ``.sdf'' suffix. 
Mode may be any combination of 
.I r, 
.I w 
and possibly 
.I f, 
corresponding in meaning to 
.I read, 
.I write 
and 
.I flush-mode.
.I r
and 
.I w
may be combined for 
.I 
readwrite mode 
.R
which is fully buffered.  
There are two modes to using sopensf(), one for opening existing files,
the other for creating new sound files.  For opening an existing
file, just supply the 
.I name 
argument, and the 
.I sfd
argument should be (char *) NULL.
When creating a file,
.I sfd
should be be a sound file descriptor
structure that has all the attributes of the file to be created,
.I
including the file name.
.R
The
.I name
argument to sopensf() is ignored.
Such a structure can be obtained by 
.B setsfd() 
or 
.B dfltsfd().
.B sopensf() 
will create the file and fill in the working fields.
In either case, the
.I name
argument can be a partial name, meaning that the entire path to the
file to be referenced will be created by sopensf(), utilizing a
data base of ``current working sound file directories'' created and
managed by the program 
.I cdsf.
File names may contain no regular expression syntax, however relative
pathnames are supported (``../foo'', or ``subdir/file'' for instance).
.PP
.nf
sopensf - system version of csound file open.
Arguments:
	* name : filename spec, can be partial name
	* mode : string of following
		* r 	read access
		* w 	write access
		* rw 	fully buffered read/write access
		[r|w] f cause sdf file to be updated after each write
	* sfd : sound file descriptor
		* if NULL, use name to determine file
		* if !NULL, use filename on sfd to determine file and
			if creating file (i.e., mode includes "w" and
			file doesn't exist) use attributes of the sdf
			to configure the file for nc, ns, fs, etc.
			The new sfd will NOT have a pointer to the 
			same disk block (if any) as the sfd passed as argument.

Actions:
* lock system
* get filename either from name or sdf
* if writing,
    * if not also reading,
	  * check sfstab to determine if writing is allowed on that device
	  * sfd must not be NULL, new file will be made from this sfd,
	      which can have been created by e.g., sfoargs().
	  * unlink old file, if any (unlink barfs if file is busy)
	  * create new sfd from one passed as argument.
    * if also reading,
	  * stop if file busy
	  * stop if it doesn't exist, 
	      * create new sfd from one passed as argument.
* else it must be readonly
    * lookup file, complain if not there.
* We should have a valid sfd by now, check it.
* open raw device,
* zero the buffer pointer
* mark sfd open for business, not at eof, set packing mode
* write updated sfd
* link on bidirectional linked list of open files
* catch interrupts
* unlock filesystem
* return sfd
.fi
.PP
.DS
closesf(sfd)
	struct sndesc *sfd;
.DE
.PP
This closes a sound file.  If the file is open for writing, its
output buffers are flushed, the free list is updated by changing all
blocks this file has claimed from ALLOCATED to USED, 
and changing any FREED blocks to UNUSED. 
The rtime and atime fields of the sndesc structure are updated to
reflect the "last time referenced and altered", i.e., now.  
If open for reading, the only thing done is to update rtime.
Next the SFD structure is written out to an appropriately named SDF file.
.NH
SOUND I/O
.PP
These routines are for doing buffered, completely general i/o to and from
sound files.  Therefore they are big and slow in comparison to routines that
would do unbuffered block transfers.  They are appropriate for 
non-time-critical applications where their flexibility is to greatest
advantage.
.nf
.B sndo
(sfd, x, st, ns, op)
    	struct sndesc *sfd; float x[]; long st, ns; char *op;
.fi
.PP
sndo() does random access variable block length sample output.  
Its arguments:
.PP
.nf
    sfd = sndesc structure pointer,
    x  = buffer of samples to write,
    st = sample index for where to start writing samples in file,
    ns = number of samples to write 
    op = special operation flags.
	
.fi
.PP
Any array size may be used with these routines.
To append to a file, write with st = sfd->fs.  sfd->fs is automatically
updated when samples are written off the end of the file.
Writing with 
st > sfd->fs causes an error return.  Writing a realtime
file with st + ns > sfd->fs expands sfd->fs, out to the limit of 
the cylinder allocation, for realtime files.  
For non-realtime files writing thusly will
simply claim more storage, out to the limit of available storage.
.PP
The op field is a string full of command characters.  At this point,
only one command is implemented.  If op is "f", sndo() will expect
to find x pointing to an array of floats, if op is "s", sndo() will
expect to get shorts.  There is an interaction here with sfd->pm.
sfd->pm determines the format sndo() will write on the disk, the op
argument to sndo() determines what kind of samples
sndo() expects to find in x.  You can hand sndo() either floats or
shorts, and ask it to write either floats or shorts and it will do
all the appropriate fixing and floating of the samples to get them into
the appropriate format on the disk.  The actions are:
.nf
if op == "f" and sfd->pm == PM16BIT,  read floats, convert to shorts and write.
if op == "f" and sfd->pm == PMFLOAT,  read floats, write floats.
if op == "s" and sfd->pm == PM16BIT,  read shorts, write shorts.
if op == "s" and sfd->pm == PMFLOAT,  read shorts, convert to floats and write.
.fi
The first case is the most usual.
.PP
.nf
sndi(sfd, x, st, ns, op)
    	struct sndesc *sfd; float x[]; long st, ns; char *op;
.sp
Arguments to sndi:
    sfd = sound file descriptor pointer,
    x  = buffer array,
    st = index to starting sample in file,
    ns = number of samples to transfer
    op = special operation.
.fi
.PP
Sndi() does the inverse of sndo(), reading off the disk and filling
array x.
Read requests off the beginning of file return an error.
Later on, sndi() will have its consciousness raised to fill in 0's
for all nonexistant samples read off the front of the file.
Reads off end of file truncate for now, but will later also return 0's.

.SH
USER-LEVEL OPEN/CLOSE
.PP
Library routines opensf() and closesf() are for user programs.
These routines use system() and popen() to manage opening and closing
files, removing the necessity for a program to be setuid disk to
read/write the 
.I csound 
system.  
.PP
.DS
struct sndesc *opensf(name, args)
	char *name, *args;
.DE
The calling sequence for opensf() is as follows.  The first argument
is the filename, the second is a string containing flags.  For opening
a file for reading, the flag can be merely "-r".  For opening a file
for writing, flags are interpreted the same as for sndout, with the addition
of -w for write: "-w -T15 -c2 -R48K", etc.
.PP
.DS
closesf(sfd)
	struct sndesc *sfd;
.DE
closesf() takes a pointer to a sndesc structure.  
.PP
Interrupt handling:
when you call opensf() you automatically buy an interrupt
handler called sfquitit(), which closes all open files on all signals, 
and does an exit(1).
.PP
.DS
sfallclose()
.DE
closes all open
sound files by repeated calles to closesf().  
.PP
For an example of reading sound files, 
see ../misc/pi.c, pi.make.
For writing sound files: ../misc/po.c, po.make.
.PP
The above routines call the following two programs via popen().
.PP
.DS
opensf [flags] filename
closesf filename1 filename2 ... filenameN
.DE
A successful call to 
.I opensf 
returns the raw text version of the open file's
SDF file on its standard output.  
The routine opensf() interfaces
to this program.  
.I closesf 
closes all named files.  It also will read
one sdf from its standard input of a file to close instead.  
.I sfallclose()
and 
.I closesf() 
interface to this program.
.PP
Needless to say, since another whole process must be sprouted and large
amounts of i/o done to open a file this way, it is considerably slower
than using sclosesf() and sopensf().
.PP
Note that even this mechanism doesn't allow the user program calling
opensf() and closesf() to write files if the protection on the raw 
sound storage device does not include writeing.  At CARL this is the
case.  User programs can only read the disk, writing must be done by
pipeing output to sndout.  This is because it is felt that all a user
has to do is to inadvertently
scribble over his in-core SFD to cause his job to write randomly all
over the disk.  There is no prophylactic like the kernel enjoys about
memory segmentation to protect the system.  However, if there is
call at a site for users to write programs that write sound files,
it is probably safe enough when all is said and done to allow this.
.NH FILE SYSTEM LOCKING
A locking scheme must exist to sequence access to the free list and
to the SDF files.  The mechanism used is the file locking scheme
of 4.2bsd.  Previous incarnations of pre-4.2BSD csound used various
other strategies, including a link lock, and a pseudo-device lock,
although they have become obsolete.  The routines are
.DS
lockfopen(file, mode)
	char *file,
	     *mode;

lockfid(fid)
	FILE *fid;

lockfclose(fid);
	FILE *fid;

unlockfid(fid)
	FILE *fid;

extern int	interlock;
.DE
.I interlock
is used as a semiphore between cooperating routines that wish to do
interlocked read/alter/write cycles on the opened file.  To do this,
the file must be opened in the correct mode, and the file truncated
to 0 length after being successfully read, before writing again.
For an example, see the library routines rlist() and wlist().
.SH EXAMPLE
.DS L
/*
 * this is a simplified version of sndin
 */

#include <stdio.h>
#include <local/sndio.h>

extern int sferror;

extern CSNDFILE *rootsfd;

main(argc, argv)
	char **argv;
{
	int otty = isatty(1), i;
	float output; 	/* output can't be register variable */
	float fsndi(); 
	CSNDFILE *sfd, *opensf();
	long int maxlen = 0; 

	/* open sound file */
	if ((sfd = opensf(argv[1], "-r")) == NULL) { 
		sfallclose(); 	/* close all open sound files */
		exit(-1); 
	}
	maxlen = sfd->fs;

	for (i = 0; i < maxlen; i++) {
		output = fsndi(sfd, i);
		if (sferror) { sfallclose(); exit(-1); }
		if (otty) printf("%d\t%f\n", i, output);
		else putfloat(&output);
	}
	if (!otty) flushfloat();
	sfallclose();	/* open files must explicitly be closed */

}
.DE
