#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define FORWARD 1
#define INVERSE 0

typedef struct { float re ; float im ; } complex ;

#define CABS(x) sqrt( (x).re*(x).re + (x).im*(x).im )

extern complex zero ;
extern complex one ;
extern float synt ;
extern float PI ;
extern float TWOPI ;
/*
 * memory allocation macro
 */
#define fvec( name, size )\
if ( ( name = (float *) calloc( size, sizeof(float) ) ) == NULL) {\
    fprintf( stderr, "Insufficient memory\n" ) ;\
    exit( -1 ) ;\
}

complex cadd( complex x, complex y ) ;
complex csub( complex x, complex y ) ;
complex cmult( complex x, complex y ) ;
complex scmult( float s, complex x ) ;
complex cdiv( complex x, complex y ) ;
complex conjg( complex x ) ;
complex csqrt( complex x ) ;
void findpoles( float coef[], complex pole[], int M ) ;
void convert( float S[], float C[], int N2, int D, int R ) ;
void findroots( complex a[], complex r[], int M ) ;
complex laguerre( complex a[], int M, complex x, float eps, int P ) ;
float lpa( float x[], int N, float b[], int M ) ;
float lpamp( float omega, float a0, float *coef, int M ) ;
void
makewindows( float H[], float A[], float S[], int Nw, int N, int I, int osc ) ;
void 
oscbank( float C[], int N, float lpcoef[], int npoles, int R, int Nw, 
int I, float P, float O[] ) ;
int readinput( float array[], int size ) ;
void rfft( float x[], int N, int forward ) ;
int shiftin( float A[], int N, int D ) ;
void shiftout( float A[], int N, int I, int n ) ;
void unconvert( float C[], float S[], int N2, int I, int R ) ;
void fold( float I[], float W[], int Nw, float O[], int N, int n ) ;
void overlapadd( float I[], int N, float W[], float O[], int Nw, int n ) ;
