#import <stdio.h>
#import <sound/sound.h>
#import <sys/file.h>

SNDSoundStruct *snd ;

#define BUF 4096

main( argc, argv ) int argc ; char *argv[] ; {
 int i, chan = 1, rd, rate = SND_RATE_LOW, byterev = 0 ;
 int fd ;
 short *snddata ;
    if ( argc == 1 ) {
	fprintf( stderr,
"tosnd usage: tosnd [-h] [-s] [-x] file < input\n" ) ;
	fprintf( stderr, 
"                    -h  is hi (44100) sampling rate [22050 assumed]\n" ) ;
	fprintf( stderr, 
"                    -s  is stereo                    [mono assumed]\n" ) ;
	fprintf( stderr, 
"                    -x  to reverse bytes        [normally not done]\n" ) ;
	fprintf( stderr, 
"                    file is name of output file     [.snd extension advised]\n" ) ;
	fprintf( stderr, 
"                    input is 16-bit linear shorts\n" ) ;
	exit( -1 ) ;
    }
    for ( i = 1 ; i < argc ; i++ ) {
	if ( !strcmp( argv[i], "-s" ) )
	    chan = 2 ;
	if ( !strcmp( argv[i], "-h" ) )
	    rate = SND_RATE_HIGH ;
	if ( !strcmp( argv[i], "-x" ) )
	    byterev++ ;
    }
    if ( 
	( fd = open( argv[argc-1], O_CREAT | O_WRONLY | O_TRUNC, 0644 ) )
    < 0 ) {
	fprintf( stderr, "tosnd: Unable to open '%s'\n", argv[argc-1] ) ;
	exit( -1 ) ;
    }
    snd = (SNDSoundStruct *) calloc( sizeof(SNDSoundStruct), 1 ) ;
    snddata = (short *) calloc( sizeof(short), BUF ) ;
    snd->magic = SND_MAGIC ;
    snd->dataLocation = sizeof(SNDSoundStruct) ;
    snd->dataSize = 0 ;
    snd->dataFormat = SND_FORMAT_LINEAR_16 ;
    snd->samplingRate = rate ;
    snd->channelCount = chan ;
    SNDWriteHeader( fd, snd ) ;
    while ( ( rd = fread( snddata, sizeof(short), BUF, stdin ) ) != 0 ) {
	if ( byterev )
		for ( i = 0 ; i < BUF ; i++ )
			snddata[i] =
			 ( snddata[i] << 8 ) | ( ( snddata[i] >> 8 ) & 0xff ) ;
	snd->dataSize += rd<<1 ;
	write( fd, snddata, rd<<1 ) ;
    }
    close( fd ) ;
    fd = open( argv[argc-1], O_WRONLY, 0644 ) ;
    SNDWriteHeader( fd, snd ) ;
    close( fd ) ;
}
