#import <stdio.h>
#import <sound/sound.h>
#import <sys/file.h>

SNDSoundStruct *snd ;

main( argc, argv ) int argc ; char *argv[] ; {
 int i, fd, chancount = 0, whichchan = 0,
	 beginsamp = 0, endsamp = -1, samp = 0, byterev = 0 ;
 FILE *fp ;
 short *sampframe, sample ;
    if ( argc == 1 ) {
	fprintf( stderr,
"fromsnd usage: fromsnd [-b X] [-d X] [-e X] [-c X] [-x] file > output\n" ) ;
	fprintf( stderr, 
"                    -b X  begin at sample frame X [0 by default]\n" ) ;
	fprintf( stderr, 
"                    -d X  duration is X sample frames [EOF by default]\n" ) ;
	fprintf( stderr, 
"                    -e X  end at sample frame X [EOF by default]\n" ) ;
	fprintf( stderr, 
"                    -c X  selects channel X [all channels by default]\n" ) ;
	fprintf( stderr, 
"                    -x    specifies byte-wise reversal [not reversed]\n" ) ;
	fprintf( stderr, 
"                                            (channels are numbered from 0)\n" ) ;
	fprintf( stderr, 
"                    output is 16-bit linear shorts\n" ) ;
	exit( -1 ) ;
    }
    for ( i = 1 ; i < argc ; i++ ) {
	if ( !strcmp( argv[i], "-c" ) ) {
	    chancount = 1 ;
	    whichchan = atoi( argv[++i] ) ;
	}
	if ( !strcmp( argv[i], "-b" ) )
	    beginsamp = atoi( argv[++i] ) ;
	if ( !strcmp( argv[i], "-d" ) )
	    endsamp = beginsamp + atoi( argv[++i] ) ;
	if ( !strcmp( argv[i], "-e" ) )
	    endsamp = atoi( argv[++i] ) ;
	if ( !strcmp( argv[i], "-x" ) )
	    byterev++ ;
    }
    if ( ( fd = open( argv[argc-1], O_CREAT | O_RDONLY, 0644 ) ) < 0 ) {
	fprintf( stderr, "fromsnd: Unable to open '%s'\n", argv[argc-1] ) ;
	exit( -1 ) ;
    }
    snd = (SNDSoundStruct *) calloc( sizeof(SNDSoundStruct), 1 ) ;
    SNDReadHeader( fd, &snd ) ;
    if ( snd->magic != SND_MAGIC ) {
	fprintf( stderr, "fromsnd: '%s' not a soundfile\n", argv[argc-1] ) ;
	exit( -1 ) ;
    }
    if ( ( fp = fdopen( fd, "r" ) ) == NULL ) {
	fprintf( stderr, "fromsnd: Unable to fdopen '%s'\n", argv[argc-1] ) ;
	exit( -1 ) ;
    }
    sampframe = (short *) calloc( sizeof(short), snd->channelCount ) ;
    rewind( fp ) ;
    for ( i = 0 ; i < snd->dataLocation ; i++ )
	fread( sampframe, 1, 1, fp ) ;
    for ( i = 0 ; i < beginsamp ; i++ ) {
	fread( sampframe, sizeof(short), snd->channelCount, fp ) ;
	++samp ;
    }
    if ( chancount == 0 )
	chancount = snd->channelCount ;
    while ( fread( sampframe, sizeof(short), snd->channelCount, fp ) != 0 ) {
	if ( byterev ) {
		for ( i = 0 ; i < snd->channelCount ; i++ ) {
		    sample = *( sampframe + i ) ;
		    sample = ( sample << 8 ) | ( ( sample >> 8 ) & 0xff ) ;
		    *( sampframe + i ) = sample ;
		}
	}
	fwrite( sampframe + whichchan, sizeof(short), chancount, stdout ) ;
	if ( ++samp > endsamp && endsamp >= 0 )
	    break ;
    }
    fclose( fp ) ;
}
