h31580
s 00000/00000/00049
d D 1.2 85/11/26 23:01:23 dgl 2 1
c eliminated LOOKED_ALREADY from getheader to cure bug 
c re. trying to add property to stdin if no header exists yet.
e
s 00049/00000/00000
d D 1.1 85/11/25 09:57:51 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <carl/defaults.h>
#include <carl/carl.h>
#include <carl/procom.h>

/*
 * fputfbuf - put buffer of floatsams
 * takes:
 * 	fp - pointer to a buffer of floats
 *	n - number of floats
 * 	iop - file descriptor
 * returns:
 * 	count of floats written
 * 	-1 on errors
 * 	0 if no output
 * side effects:
 * 	sets up buffer for samples
 * 	if a header is present, it is written.
 */

fputfbuf(fp, n, iop)
	register float *fp;
	register int n;
	FILE *iop;
{
	register struct fltbuf *fbp;
	register int i;

	fbp = &fb[fileno(iop)];		/* get fid buffer pointer */
	if (fbp->gpflt == 0) {		/* first time? */
		set_sample_size(sizeof(float));
		if (pinit(iop))		/* make sure everything is set up */
			return(-1);
	}

	for (i = 0; i < n; i++) {
		if (fbp->pos >= fbp->bufsiz) {
			fbp->n = write(fileno(iop), fbp->fbuf, P_BUFSIZE);
			if (fbp->n <= 0)
				return(fbp->n);
			fbp->n /= fbp->ssize;
			fbp->pos = 0;
		}
		fbp->fbuf[fbp->pos++] = *fp++;
	}
	return(n);
}
E 1
