/* fsndi()

	fsndi() exists only to provide backwards compatibility with
	some of the CARL software which relies on custom routines
	to read and write soundfiles.  It takes two arguments: a
	pointer to a special soundfile structure, and the index of
	the sample desired.  Note that the index is NOT the sample
	frame but the actual sample.

	The return value is the value of the sample as a floatsam.
	If an error occurs, 0 is returned, and the external variable
	"sferror" will be set to a non-zero value defined in snd.h.
	Note that a return value of 0 does NOT necessarily mean
	that an error occured; sferror has to be explicitly checked
	for a non-zero value;

	Abe Singer, June 1992
*/

#define SEEK_SET	0	/* for some reason, this isn't defined for */
				/* the -bsd compiler option */
#ifdef nextsf
#include <carl/snd.h>

#import <cthreads.h>
#import <sound/sound.h>
#import <sys/file.h>
#import <sys/types.h>
#import <sys/stat.h>

float	fsndi(sfp, sampno)

struct sndesc	*sfp;			/* Soundfile pointer */
long		sampno;			/* Sample number */

{
	short new;
	long pos;

	sferror = 0;
	if (!sfp || !sfp->fp) {
		sferror = SF_BADPTR;
		return((float) 0);
	}
	if (sampno == sfp->index)	/* If already read, return it quick */
		return(sfp->sample);
	if ((sampno < 0) || (sampno >= sfp->fs))
		return((float) 0.0);	/* Return 0 if outta range */

	pos = sfp->headsize + (sampno * sizeof(short));	
	if (pos != ftell(sfp->fp))
		fseek(sfp->fp, pos, SEEK_SET);	
	if (!(fread(&new, (size_t) sizeof(short), (size_t) 1, sfp->fp))) {
			sferror = SF_BADREAD;	/* return 0 if unable to read */
			return((float) 0.0);
	}
	sfp->sample = (float) new / (float) SF_FACTOR; /* Convert to floatsam */
	sfp->index = sampno;
	return(sfp->sample);	/* Done.  Return sample. */
}

#endif
