
#import "sndio.h"

// short to short output functions

void stos(short *sp_in,long begin,long end,int chan_num)
{
    if(ascii_out == YES)	astos(sp_in,begin,end,chan_num);

    else if(chanspec == NULL)	ncstos(sp_in,begin,end);

    else			cstos(sp_in,begin,end,chan_num);
}

// short to short--pipe or file output with no channel filtering

void ncstos(short *sp_in,long begin,long end,int chan_num)
{
    register long	i;
    register short	*sp;
    register long	full;
    register int	bmax = (BUFSIZE / sizeof(short)) - 1;

    sp = sp_in;

    full = -1;

    for(i = begin; i < end; i++, sp++) {

	sbuffer[++full] = *sp;

	if(full == bmax) {
	    fwrite((void *) sbuffer,BUFSIZE,1,ofp);
	    full = -1;
	}
    }
    if(full >= 0)	fwrite((void *) sbuffer,((full + 1) * sizeof(short)),1,ofp);
}

// short to short--pipe or file output with channel filtering

void cstos(short *sp_in,long begin,long end,int chan_num)
{
    register long	i;
    register short	*sp;
    register int	nc;
    register long	full;
    register int	bmax = (BUFSIZE / sizeof(short)) - 1;
    register int	y = -1;

    sp = sp_in;
    nc = chan_num;

    full = -1;

    for(i = begin; i < end; i++, sp++) {

	if(!chans[++y >= nc ? (y = 0) : y])	continue;

	sbuffer[++full] = *sp;

	if(full == bmax) {
	    fwrite((void *) sbuffer,BUFSIZE,1,ofp);
	    full = -1;
	}
    }
    if(full >= 0)	fwrite((void *) sbuffer,((full + 1) * sizeof(short)),1,ofp);
}

// short to short--ascii output

void astos(short *sp_in,long begin,long end,int chan_num)
{
    register long	i;
    register short	*sp;
    register int	nc;
    register int	y = -1;
    int			floor;

    sp = sp_in;
    nc = chan_num;

    if(out_index == 's') {

	for(i = begin; i < end; i++, sp++) {
    
	    if(chans[++y >= nc ? (y = 0) : y])	fprintf(ofp,"%d\t%d\n",(int) i / nc,*sp);
	}
    }
    else if(out_index == 't') {

	for(i = begin; i < end; i++, sp++) {
    
	    if(chans[++y >= nc ? (y = 0) : y]) {

		floor = (int) i / nc;

		fprintf(ofp,"%f\t%d\n",((float) floor) / samrate,*sp);
	    }
	}
    }
    else {

	for(i = begin; i < end; i++, sp++) {
    
	    if(chans[++y >= nc ? (y = 0) : y])	fprintf(ofp,"%d\n",*sp);
	}
    }
}

// short to short--"headless file" binary buffering before call to stos()
//		    we know dataSize but have no snd_pointer to data

void stoshf(FILE *bbfp,long begin,long end,int chan_total)
{
    short	*nhp;
    int		whole_frms;		// number of sample frames to buffer
    int		pass_end;

    whole_frms = (int) BUFSIZE / chan_total;
    whole_frms *= chan_total;

    pass_end = begin + whole_frms;

    if(pass_end > end)	pass_end = end;

    while(begin < end) {

	fread((void *) sinbuf,sizeof(short),pass_end - begin,bbfp);

	nhp = sinbuf;			// nhp subs for snd_pointer

	stos(nhp,begin,pass_end,chan_total);

	begin = pass_end;

	pass_end = begin + whole_frms;

	if(pass_end > end)	pass_end = end;
    }
}

// short to short--piped binary input buffering before call to stos()
//		    we don't know dataSize or have snd_pointer to data

void stosp(FILE *bbfp,long begin,long end,int chan_total)
{
    short		*nhp;
    int			whole_frms;	// number of sample frames to buffer
    int			pass_end;
    unsigned long	num_in;		// actual number of smaples in sobuf[]

    whole_frms = (int) BUFSIZE / chan_total;
    whole_frms *= chan_total;			// want to process by whole frames

    pass_end = begin + whole_frms;

    if(pass_end > end)	pass_end = end;

    while(begin < end) {

	num_in = fread((void *) sinbuf,sizeof(short),pass_end - begin,bbfp);

	nhp = sinbuf;			// nhp subs for snd_pointer
    
	if(num_in < (pass_end - begin)) {	// ran out of data

	    pass_end = begin + num_in;

	    stos(nhp,begin,pass_end,chan_total);

	    begin = end;		// we are done
	}
	else {
    
	    stos(nhp,begin,pass_end,chan_total);
    
	    begin = pass_end;
    
	    pass_end = begin + whole_frms;
    
	    if(pass_end > end)	pass_end = end;
	}
    }
}

// short to short--ascii input buffering before call to stos()
//		    we don't know dataSize or have snd_pointer to data

void stosa(FILE *bbfp,long begin,long end,int chan_total)
{
    short		*nhp;
    int			i_tmp;
    int			whole_frms;	// number of sample frames to buffer
    int			pass_end;
    unsigned long	num_in;		// actual number of smaples in sobuf[]

    whole_frms = (int) BUFSIZE / chan_total;
    whole_frms *= chan_total;			// want to process by whole frames

    pass_end = begin + whole_frms;

    if(pass_end > end)	pass_end = end;

    while(begin < end) {

	for(num_in = 0; num_in < whole_frms; num_in++) {

	    if(in_index == 's') {
	
		if(fscanf(ifp,"%*d %d",&i_tmp) == EOF)	break;		
	    }
	    else if(in_index == 't') {
	
		if(fscanf(ifp,"%*f %d",&i_tmp) == EOF)	break;
	    }
	    else {
		if(fscanf(ifp,"%d",&i_tmp) == EOF)	break;		
	    }
	    sinbuf[num_in] = (short) i_tmp;
	}
	nhp = sinbuf;			// nhp subs for snd_pointer
    
	if(num_in < (pass_end - begin)) {	// ran out of data

	    pass_end = begin + num_in;

	    stos(nhp,begin,pass_end,chan_total);

	    begin = end;		// we are done
	}
	else {
    
	    stos(nhp,begin,pass_end,chan_total);
    
	    begin = pass_end;
    
	    pass_end = begin + whole_frms;
    
	    if(pass_end > end)	pass_end = end;
	}
    }
}

