
#import "sndio.h"

// float to short output conversion functions

int ftos(float *sp_in,long begin,long end,int chan_num)
{
    if(ascii_out == YES)	return(aftos(sp_in,begin,end,chan_num));

    else if(chanspec == NULL)	return(ncftos(sp_in,begin,end));

    else			return(cftos(sp_in,begin,end,chan_num));
}

// float to short--pipe or file output with no channel filtering

int ncftos(float *sp_in,long begin,long end,int chan_num)
{
    int			clip = 0;
    register long	i;
    register float	*sp;
    register long	full;
    register int	bmax = (BUFSIZE / sizeof(short)) - 1;

    sp = sp_in;

    full = -1;

    for(i = begin; i < end; i++, sp++) {

	if(*sp > 1.0) {
	    *sp = 1.0;		clip++;
	}
	else if(*sp < -1.0) {
	    *sp = -1.0;		clip++;
	}
	sbuffer[++full] = (short) (*sp * 32767.0);

	if(full == bmax) {
	    fwrite((void *) sbuffer,BUFSIZE,1,ofp);
	    full = -1;
	}
    }
    if(full >= 0)	fwrite((void *) sbuffer,((full + 1) * sizeof(short)),1,ofp);

    return(clip);
}

// float to short--pipe or file output with channel filtering

int cftos(float *sp_in,long begin,long end,int chan_num)
{
    int			clip = 0;
    register long	i;
    register float	*sp;
    register int	nc;
    register long	full;
    register int	bmax = (BUFSIZE / sizeof(short)) - 1;
    register int	y = -1;

    sp = sp_in;
    nc = chan_num;

    full = -1;

    for(i = begin; i < end; i++, sp++) {

	if(!chans[++y >= nc ? (y = 0) : y])	continue;

	if(*sp > 1.0) {
	    *sp = 1.0;		clip++;
	}
	else if(*sp < -1.0) {
	    *sp = -1.0;		clip++;
	}
	sbuffer[++full] = (short) (*sp * 32767.0);

	if(full == bmax) {
	    fwrite((void *) sbuffer,BUFSIZE,1,ofp);
	    full = -1;
	}
    }
    if(full >= 0)	fwrite((void *) sbuffer,((full + 1) * sizeof(short)),1,ofp);

    return(clip);
}

// float to short--ascii output

int aftos(float *sp_in,long begin,long end,int chan_num)
{
    int			clip = 0;
    register long	i;
    register float	*sp;
    register int	nc;
    register int	y = -1;
    int			floor;

    sp = sp_in;
    nc = chan_num;

    for(i = begin; i < end; i++, sp++) {

	if(chans[++y >= nc ? (y = 0) : y]) {

	    if(*sp > 1.0) {
		*sp = 1.0;		clip++;
	    }
	    else if(*sp < -1.0) {
		*sp = -1.0;		clip++;
	    }
	    if(out_index == 's')    fprintf(ofp,"%d\t%d\n",(int) i / nc,(int) (*sp * 32767.0));

	    else if(out_index == 't') {

		floor = (int) i / nc;

		fprintf(ofp,"%f\t%d\n",((float) floor) / samrate,(int) (*sp * 32767.0));
	    }
	    else	fprintf(ofp,"%d\n",(int) (*sp * 32767.0));
	}
    }
    return(clip);
}

// float to short--"headless file" binary buffering before call to ftos()
//		    we know dataSize but have no snd_pointer to data

int ftoshf(FILE *bbfp,long begin,long end,int chan_total)
{
    float	*nhp;
    int		whole_frms;		// number of sample frames to buffer
    int		pass_end;
    int		clip = 0;

    whole_frms = (int) BUFSIZE / chan_total;
    whole_frms *= chan_total;

    pass_end = begin + whole_frms;

    if(pass_end > end)	pass_end = end;

    while(begin < end) {

	fread((void *) finbuf,(sizeof(float) * (pass_end - begin)),1,bbfp);

	nhp = finbuf;			// nhp subs for snd_pointer

	clip += ftos(nhp,begin,pass_end,chan_total);

	begin = pass_end;

	pass_end = begin + whole_frms;

	if(pass_end > end)	pass_end = end;
    }
    return(clip);
}

// float to short--piped binary input buffering before call to ftos()
//		    we don't know dataSize or have snd_pointer to data

int ftosp(FILE *bbfp,long begin,long end,int chan_total)
{
    float		*nhp;
    int			whole_frms;	// number of sample frames to buffer
    int			pass_end;
    unsigned long	num_in;		// actual number of smaples in sobuf[]
    int			clip = 0;

    whole_frms = (int) BUFSIZE / chan_total;
    whole_frms *= chan_total;			// want to process by whole frames

    pass_end = begin + whole_frms;

    if(pass_end > end)	pass_end = end;

    while(begin < end) {

	num_in = fread((void *) finbuf,sizeof(float),pass_end - begin,bbfp);

	nhp = finbuf;			// nhp subs for snd_pointer
    
	if(num_in < (pass_end - begin)) {	// ran out of data

	    pass_end = begin + num_in;

	    clip += ftos(nhp,begin,pass_end,chan_total);

	    begin = end;		// we are done
	}
	else {
    
	    clip += ftos(nhp,begin,pass_end,chan_total);
    
	    begin = pass_end;
    
	    pass_end = begin + whole_frms;
    
	    if(pass_end > end)	pass_end = end;
	}
    }
    return(clip);
}

// float to short--ascii input buffering before call to ftos()
//		    we don't know dataSize or have snd_pointer to data

int ftosa(FILE *bbfp,long begin,long end,int chan_total)
{
    float		*nhp;
    float		f_tmp;
    int			whole_frms;	// number of sample frames to buffer
    int			pass_end;
    unsigned long	num_in;		// actual number of smaples in sobuf[]
    int			clip = 0;

    whole_frms = (int) BUFSIZE / chan_total;
    whole_frms *= chan_total;			// want to process by whole frames

    pass_end = begin + whole_frms;

    if(pass_end > end)	pass_end = end;

    while(begin < end) {

	for(num_in = 0; num_in < whole_frms; num_in++) {

	    if(in_index == 's') {
	
		if(fscanf(ifp,"%*d %f",&f_tmp) == EOF)	break;		
	    }
	    else if(in_index == 't') {
	
		if(fscanf(ifp,"%*f %f",&f_tmp) == EOF)	break;		
	    }
	    else {
		if(fscanf(ifp,"%f",&f_tmp) == EOF)	break;		
	    }
	    finbuf[num_in] = f_tmp;
	}
	nhp = finbuf;			// nhp subs for snd_pointer
    
	if(num_in < (pass_end - begin)) {	// ran out of data

	    pass_end = begin + num_in;

	    clip += ftos(nhp,begin,pass_end,chan_total);

	    begin = end;		// we are done
	}
	else {
    
	    clip += ftos(nhp,begin,pass_end,chan_total);
    
	    begin = pass_end;
    
	    pass_end = begin + whole_frms;
    
	    if(pass_end > end)	pass_end = end;
	}
    }
    return(clip);
}
